<?php
namespace ReyCore\ACF;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Fields {

	private static $fields = [];

	function __construct(){
		add_action('acf/init', [$this, 'init']);
	}

	function init(){

		if( ! function_exists('acf_add_local_field_group') ){
			return;
		}

		// load predefined fields
		if( ! apply_filters('reycore/acf/use_predefined_fields', ! (defined('REYCORE_ACF_DISABLE_FIELDS') && REYCORE_ACF_DISABLE_FIELDS)) ){
			return;
		}

		self::$fields = [
			'global_sections'    => $this->f__global_sections(),
			'product_settings'   => $this->f__product_settings(),
			'page_settings'      => $this->f__page_settings(),
			'theme_settings'     => $this->f__theme_settings(),
			'icon_menu_settings' => $this->f__icon_menu_settings(),
		];

		do_action('reycore/acf/fields', $this);

		foreach (self::$fields as $key => $fields) {
			acf_add_local_field_group($fields);
		}
	}

	public function set_group_fields( $group, $new_field, $after = '' ){

		if( ! isset(self::$fields[$group]) ){
			return;
		}

		if( ! $after ){
			array_push(self::$fields[$group]['fields'], $new_field );
		}
		else {
			// find key
			$key = array_search($after, array_column( self::$fields[$group]['fields'], 'name' ) );
			// add to group
			self::$fields[$group]['fields'] = $this->array_insert_after( self::$fields[$group]['fields'], $key, [$new_field] );
		}

	}

	public function array_insert_after( array $array, $key, array $new ) {

		$keys = array_keys( $array );
		$index = array_search( $key, $keys );
		$pos = false === $index ? count( $array ) : $index + 1;

		return array_merge( array_slice( $array, 0, $pos ), $new, array_slice( $array, $pos ) );
	}

	public function f__global_sections(){
		return [
			'key' => 'group_5c4c18df892d1',
			'title' => 'Global Sections',
			'fields' => array(
				array(
					'key' => 'field_5c4c18fb06515',
					'label' => 'Type',
					'name' => 'gs_type',
					'type' => 'button_group',
					'instructions' => 'Select type of global section. <br>Headers & Footers need to be manually assigned in Customizer > Header (Footer) > General , or for specific pages, into the page\' custom options. <br>Generic sections can be assigned to different page positions, either in Customizer > General > Generic Sections (for site-wide usage), or specific pages, into the page\' custom options.',
					'required' => 1,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'generic' => 'Generic Section',
						'header' => 'Header',
						'cover' => 'Page Cover',
						'footer' => 'Footer',
					),
					'allow_null' => 0,
					'default_value' => 'generic',
					'layout' => 'horizontal',
					'return_format' => 'value',
				),
			),
			'location' => array(
				array(
					array(
						'param' => 'post_type',
						'operator' => '==',
						'value' => 'rey-global-sections',
					),
				),
			),
			'menu_order' => 0,
			'position' => 'acf_after_title',
			'style' => 'default',
			'label_placement' => 'top',
			'instruction_placement' => 'label',
			'hide_on_screen' => '',
			'active' => true,
			'description' => '',
		];
	}

	public function f__product_settings(){

		$product_settings = array(

			array(
				'key' => 'field_5d4ff5734de9f',
				'label' => 'Misc.',
				'name' => '',
				'type' => 'tab',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'placement' => 'top',
				'endpoint' => 0,
			),

			array(
				'key' => 'field_5d4ff5a94dea0',
				'label' => 'Product Info Block/Tab',
				'name' => 'product_info',
				'type' => 'select',
				'instructions' => 'Select if you want to show or hide the "Information" content, which is displayed after the product summary. The content is pre-defined in "Customizer > WooCommerce > Product Page - Content" panel. You can also select Custom content, and you will be able to override it.',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => 'rey-decrease-list-size',
					'id' => '',
				),
				'choices' => array(
					1 => 'Show',
					2 => 'Hide',
					'custom' => 'Custom',
				),
				'default_value' => false,
				'allow_null' => 1,
				'multiple' => 0,
				'ui' => 0,
				'return_format' => 'value',
				'ajax' => 0,
				'placeholder' => '',

			),

			array(
				'key' => 'field_5d4ff6c64dea1',
				'label' => 'Custom Content',
				'name' => 'product_info_content',
				'type' => 'wysiwyg',
				'instructions' => 'Override the custom content pre-defined in "Customizer > WooCommerce > Product Page - Content" panel.',
				'required' => 0,
				'conditional_logic' => array(
					array(
						array(
							'field' => 'field_5d4ff5a94dea0',
							'operator' => '==',
							'value' => 'custom',
						),
					),
				),
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'default_value' => '',
				'tabs' => 'all',
				'toolbar' => 'full',
				'media_upload' => 1,
				'delay' => 1,

			),

			array(
				'key' => 'field_60a1063400686',
				'label' => 'Specifications Block/Tab',
				'name' => 'single_specifications_block',
				'type' => 'true_false',
				'instructions' => 'Disable if you don\'t want to display the Specifications block/tab.',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'message' => '',
				'default_value' => 1,
				'ui' => 1,
				'ui_on_text' => 'Show',
				'ui_off_text' => 'Hide',

			),

			array(
				'key' => 'field_5e24805172eb5',
				'label' => 'Add to cart',
				'name' => '',
				'type' => 'tab',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'placement' => 'top',
				'endpoint' => 0,

			),
			array(
				'key' => 'field_5e24815a72eb8',
				'label' => 'Content *Before* Add to cart button',
				'name' => 'enable_text_before_add_to_cart',
				'type' => 'select',
				'instructions' => 'Select if you want to show some content *Before* the Add to Cart button. You can globally assign content on all products by accessing "Customizer > WooCommerce > Product Page - Components" panel and enable the "Text Before Add to cart button" option.',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => 'rey-decrease-list-size',
					'id' => '',
				),
				'choices' => array(
					'true' => 'Show',
					'false' => 'Hide',
					'custom' => 'Show Custom Text',
				),
				'default_value' => false,
				'allow_null' => 1,
				'multiple' => 0,
				'ui' => 0,
				'return_format' => 'value',
				'ajax' => 0,
				'placeholder' => '',
			),
			array(
				'key' => 'field_5e24810172eb7',
				'label' => 'Custom text before Add to cart button',
				'name' => 'text_before_add_to_cart',
				'type' => 'textarea',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => array(
					array(
						array(
							'field' => 'field_5e24815a72eb8',
							'operator' => '==',
							'value' => 'custom',
						),
					),
				),
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'default_value' => '',
				'placeholder' => '',
				'maxlength' => '',
				'rows' => '',
				'new_lines' => 'wpautop',
			),
			array(
				'key' => 'field_5e24889d03179',
				'label' => 'Content *After* Add to cart button',
				'name' => 'enable_text_after_add_to_cart',
				'type' => 'select',
				'instructions' => 'Select if you want to show some content *After* the Add to Cart button. You can globally assign content on all products by accessing "Customizer > WooCommerce > Product Page - Components" panel and enable the "Text After Add to cart button" option.',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => 'rey-decrease-list-size',
					'id' => '',
				),
				'choices' => array(
					'true' => 'Show',
					'false' => 'Hide',
					'custom' => 'Show Custom Text',
				),
				'default_value' => false,
				'allow_null' => 1,
				'multiple' => 0,
				'ui' => 0,
				'return_format' => 'value',
				'ajax' => 0,
				'placeholder' => '',
			),
			array(
				'key' => 'field_5e2488ad0317a',
				'label' => 'Custom text After Add to cart button',
				'name' => 'text_after_add_to_cart',
				'type' => 'textarea',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => array(
					array(
						array(
							'field' => 'field_5e24889d03179',
							'operator' => '==',
							'value' => 'custom',
						),
					),
				),
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'default_value' => '',
				'placeholder' => '',
				'maxlength' => '',
				'rows' => '',
				'new_lines' => 'wpautop',
			),
		);

		return [
			'key' => 'group_5d4ff536a2684',
			'title' => 'Product settings',
			'fields' => $product_settings,
			'location' => array(
				array(
					array(
						'param' => 'post_type',
						'operator' => '==',
						'value' => 'product',
					),
				),
			),
			'menu_order' => 0,
			'position' => 'normal',
			'style' => 'default',
			'label_placement' => 'top',
			'instruction_placement' => 'label',
			'hide_on_screen' => '',
			'active' => true,
			'description' => '',

		];

	}

	public function f__page_settings(){
		return [
			'key' => 'group_5c4ad0bd35b33',
			'title' => 'Page Settings',
			'fields' => array(
				array(
					'key' => 'field_5c4ad13830432',
					'label' => 'General',
					'name' => '',
					'type' => 'tab',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'placement' => 'top',
					'endpoint' => 0,
				),
				array(
					'key' => 'field_5c4ad1920206f',
					'label' => 'Title Display',
					'name' => 'title_display',
					'type' => 'select',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '--size-1',
						'id' => '',
					),
					'choices' => array(
						'show' => 'Show',
						'hide' => 'Hide',
					),
					'default_value' => false,
					'allow_null' => 1,
					'multiple' => 0,
					'ui' => 0,
					'return_format' => 'value',
					'ajax' => 0,
					'placeholder' => '',
				),
				array(
					'key' => 'field_5ca5a644e6fc2',
					'label' => 'Page Cover',
					'name' => 'page_cover',
					'type' => 'select',
					'instructions' => 'Enable/disable or change the pre-assigned page cover in Customizer > Page Cover.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => 'rey-decrease-list-size',
						'id' => '',
					),
					'choices' => array(
					),
					'default_value' => false,
					'allow_null' => 1,
					'multiple' => 0,
					'ui' => 0,
					'return_format' => 'value',
					'ajax' => 0,
					'placeholder' => '',
				),
				array(
					'key' => 'field_5db54e5bb0124',
					'label' => 'Body CSS Classes',
					'name' => 'rey_body_class',
					'type' => 'text',
					'instructions' => 'Add CSS classes that will be appended to the body tag\'s class attribute.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => 'rey-decrease-list-size',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'maxlength' => '',
				),
				array(
					'key' => 'field_5c4ad17030433',
					'label' => 'Header',
					'name' => '',
					'type' => 'tab',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'placement' => 'top',
					'endpoint' => 0,
				),
				array(
					'key' => 'field_5c4bfd132e0db',
					'label' => 'Header Layout',
					'name' => 'header_layout_type',
					'type' => 'select',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => 'rey-decrease-list-size',
						'id' => '',
					),
					'choices' => array(
						'none' => 'None',
						'default' => 'Default Header (Non-Elementor)',
					),
					'default_value' => false,
					'allow_null' => 1,
					'multiple' => 0,
					'ui' => 0,
					'return_format' => 'value',
					'ajax' => 0,
					'placeholder' => '',
				),
				array(
					'key' => 'field_5c77bde02960c',
					'label' => 'Header Text',
					'name' => 'header_text_color',
					'type' => 'color_picker',
					'instructions' => 'This will override the Header\'s text color. Please know that some elements may not be colored properly, so in such cases it\'s probably recommended to customize the colors right into the Header Global Section you\'re currently using.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_5c4bfd132e0db',
								'operator' => '!=',
								'value' => 'none',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'enable_opacity' => 1,
					'default_value' => '',
				),
				array(
					'key' => 'field_5c4d67245ab37',
					'label' => 'Header Position',
					'name' => 'header_position',
					'type' => 'select',
					'instructions' => 'Select how the header will position itself on top. This option will override the one selected in Customizer > Header > General. Read more about <a href="' . reycore__support_url('kb/header-positions-and-overlapping-content/') . '" target="_blank">Header Positions and Overlapping Content</a>',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_5c4bfd132e0db',
								'operator' => '!=',
								'value' => 'none',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => 'rey-decrease-list-size',
						'id' => '',
					),
					'choices' => array(
						'rel' => 'Default (Relative)',
						'absolute' => 'Absolute (over content)',
						'fixed' => 'Fixed (Sticky and over content)',
					),
					'default_value' => false,
					'allow_null' => 1,
					'multiple' => 0,
					'ui' => 0,
					'return_format' => 'value',
					'ajax' => 0,
					'placeholder' => '',
				),
				array(
					'key' => 'field_5df93bde34670',
					'label' => 'Overlap Content',
					'name' => 'header_fixed_overlap',
					'type' => 'select',
					'instructions' => 'If enabled, the header will behave like "relative" header. This option will override the global option set in Customizer > Header > General > Header Position -	Overlap Content.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_5c4d67245ab37',
								'operator' => '==',
								'value' => 'fixed',
							),
						),
						array(
							array(
								'field' => 'field_5c4d67245ab37',
								'operator' => '==',
								'value' => 'absolute',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '--size-1 rey-acf-responsive --desktop --dependent',
						'id' => '',
					),
					'choices' => array(
						'true' => 'Yes',
						'false' => 'No',
					),
					'default_value' => false,
					'allow_null' => 1,
					'multiple' => 0,
					'ui' => 0,
					'return_format' => 'value',
					'ajax' => 0,
					'placeholder' => '',
				),
				array(
					'key' => 'field_5e00c7041717e',
					'label' => 'Overlap Content (tablet)',
					'name' => 'header_fixed_overlap_tablet',
					'type' => 'select',
					'instructions' => 'If enabled, the header will behave like "relative" header. This option will override the global option set in Customizer > Header > General > Header Position -	Overlap Content.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_5c4d67245ab37',
								'operator' => '==',
								'value' => 'fixed',
							),
						),
						array(
							array(
								'field' => 'field_5c4d67245ab37',
								'operator' => '==',
								'value' => 'absolute',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '--size-1 rey-acf-responsive --tablet	--dependent',
						'id' => '',
					),
					'choices' => array(
						'true' => 'Yes',
						'false' => 'No',
					),
					'default_value' => false,
					'allow_null' => 1,
					'multiple' => 0,
					'ui' => 0,
					'return_format' => 'value',
					'ajax' => 0,
					'placeholder' => '',
				),
				array(
					'key' => 'field_5e00c7361717f',
					'label' => 'Overlap Content (mobile)',
					'name' => 'header_fixed_overlap_mobile',
					'type' => 'select',
					'instructions' => 'If enabled, the header will behave like "relative" header. This option will override the global option set in Customizer > Header > General > Header Position -	Overlap Content.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_5c4d67245ab37',
								'operator' => '==',
								'value' => 'fixed',
							),
						),
						array(
							array(
								'field' => 'field_5c4d67245ab37',
								'operator' => '==',
								'value' => 'absolute',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '--size-1 rey-acf-responsive --mobile	--dependent',
						'id' => '',
					),
					'choices' => array(
						'true' => 'Yes',
						'false' => 'No',
					),
					'default_value' => false,
					'allow_null' => 1,
					'multiple' => 0,
					'ui' => 0,
					'return_format' => 'value',
					'ajax' => 0,
					'placeholder' => '',
				),
				array(
					'key' => 'field_5da5d16549bc4',
					'label' => 'Custom Logo',
					'name' => 'custom_logo',
					'type' => 'image',
					'instructions' => 'Add an image here if you want this page to display a different logo image. If using a Header - Global Section, make sure the Header - Logo element doesn\'t have "Override settings" option enabled.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'return_format' => 'id',
					'preview_size' => 'thumbnail',
					'library' => 'all',
					'min_width' => '',
					'min_height' => '',
					'min_size' => '',
					'max_width' => '',
					'max_height' => '',
					'max_size' => '',
					'mime_types' => '',
				),
				array(
					'key' => 'field_5da5d1d449bc5',
					'label' => 'Custom Mobile Logo',
					'name' => 'logo_mobile',
					'type' => 'image',
					'instructions' => 'Add an image here if you want this page to display a different *mobile* logo image. If using a Header - Global Section, make sure the Header - Logo element doesn\'t have "Override settings" option enabled.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'return_format' => 'id',
					'preview_size' => 'thumbnail',
					'library' => 'all',
					'min_width' => '',
					'min_height' => '',
					'min_size' => '',
					'max_width' => '',
					'max_height' => '',
					'max_size' => '',
					'mime_types' => '',
				),
				array(
					'key' => 'field_5c4ae4aa46da7',
					'label' => 'Footer',
					'name' => '',
					'type' => 'tab',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'placement' => 'top',
					'endpoint' => 0,
				),
				array(
					'key' => 'field_5c4ae4ba46da8',
					'label' => 'Footer Layout',
					'name' => 'footer_layout_type',
					'type' => 'select',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => 'rey-decrease-list-size',
						'id' => '',
					),
					'choices' => array(
					),
					'default_value' => false,
					'allow_null' => 1,
					'multiple' => 0,
					'ui' => 0,
					'return_format' => 'value',
					'ajax' => 0,
					'placeholder' => '',
				),
				array(
					'key' => 'field_5ecd3bb346234',
					'label' => 'Page layout',
					'name' => '',
					'type' => 'tab',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'placement' => 'top',
					'endpoint' => 0,
				),
				array(
					'key' => 'field_5ecd3bc846235',
					'label' => 'Container width',
					'name' => 'custom_container_width',
					'type' => 'select',
					'instructions' => 'Select the page container width.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => 'rey-decrease-list-size',
						'id' => '',
					),
					'choices' => array(
						'px' => 'Pixels (px)',
						'vw' => 'Viewport Width (vw)',
						'full' => 'Full Width',
					),
					'default_value' => false,
					'allow_null' => 1,
					'multiple' => 0,
					'ui' => 0,
					'return_format' => 'value',
					'ajax' => 0,
					'placeholder' => '',
				),
				array(
					'key' => 'field_5ecd3ca546236',
					'label' => 'Container Width (px)',
					'name' => 'container_width_px',
					'type' => 'range',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_5ecd3bc846235',
								'operator' => '==',
								'value' => 'px',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => 1440,
					'min' => 480,
					'max' => 2560,
					'step' => '',
					'prepend' => '',
					'append' => 'px',
				),
				array(
					'key' => 'field_5ecd3d1946237',
					'label' => 'Container Width (vw)',
					'name' => 'container_width_vw',
					'type' => 'range',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_5ecd3bc846235',
								'operator' => '==',
								'value' => 'vw',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => 90,
					'min' => 1,
					'max' => 100,
					'step' => '',
					'prepend' => '',
					'append' => 'vw',
				),
				array(
					'key' => 'field_5ecd435aadec0',
					'label' => 'Apply only to main content',
					'name' => 'apply_only_to_main_content',
					'type' => 'true_false',
					'instructions' => 'If enabled, this container width will only be applied to the main content (excluding header, footer etc.)',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_5ecd3bc846235',
								'operator' => '!=empty',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_5dbd36274ec3a',
					'label' => 'Container Horizontal Margins',
					'name' => 'container_spacing',
					'type' => 'number',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => get_theme_mod('container_spacing', 15),
					'prepend' => '',
					'append' => 'px',
					'min' => '',
					'max' => '',
					'step' => '',
				),
				array(
					'key' => 'field_5ecd3daa46239',
					'label' => 'Container Vertical Padding',
					'name' => 'content_padding',
					'type' => 'group',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '--size-3 rey-acf-dimensions',
						'id' => '',
					),
					'layout' => 'table',
					'sub_fields' => array(
						array(
							'key' => 'field_5ecd3db74623a',
							'label' => 'Top',
							'name' => 'top',
							'type' => 'number',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => \ReyCore\ACF\Helper::get_container_padding_placeholders('top'),
							'prepend' => '',
							'append' => 'px',
							'min' => '',
							'max' => '',
							'step' => '',
						),
						array(
							'key' => 'field_5ecd3ddd4623c',
							'label' => 'Bottom',
							'name' => 'bottom',
							'type' => 'number',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => \ReyCore\ACF\Helper::get_container_padding_placeholders('bottom'),
							'prepend' => '',
							'append' => 'px',
							'min' => '',
							'max' => '',
							'step' => '',
						),
					),
				),
				array(
					'key' => 'field_5c4c848308731',
					'label' => 'Advanced',
					'name' => '',
					'type' => 'tab',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'placement' => 'top',
					'endpoint' => 0,
				),
				array(
					'key' => 'field_5c4cba8c273ad',
					'label' => 'Global Sections',
					'name' => 'global_sections',
					'type' => 'repeater',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => 'rey-acf-repeater-list',
						'id' => '',
					),
					'collapsed' => '',
					'min' => 0,
					'max' => 0,
					'layout' => 'table',
					'button_label' => 'Add Global Section',
					'sub_fields' => array(
						array(
							'key' => 'field_5c4cbbb2273af',
							'label' => 'Generic Sections List',
							'name' => 'global_sections_id',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => 'rey-decrease-list-size',
								'id' => '',
							),
							'choices' => array(
							),
							'default_value' => false,
							'allow_null' => 1,
							'multiple' => 0,
							'ui' => 1,
							'ajax' => 0,
							'return_format' => 'value',
							'placeholder' => '',
						),
						array(
							'key' => 'field_5c4cbb49273ae',
							'label' => 'Position',
							'name' => 'global_sections_hook',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => 'rey-decrease-list-size',
								'id' => '',
							),
							'choices' => array(
								'before_site_wrapper' => 'Before Site Wrapper',
								'before_header' => 'Before Header',
								'after_header' => 'After Header',
								'before_site_container' => 'Before Site Container',
								'after_site_container' => 'After Site Container',
								'before_footer' => 'Before Footer',
								'after_footer' => 'After Footer',
								'after_site_wrapper' => 'After Site Wrapper',
								'wp_body_open' => 'Body Start (wp_body_open)',
								'wp_footer' => 'Body End (wp_footer)',
							),
							'default_value' => false,
							'allow_null' => 1,
							'multiple' => 0,
							'ui' => 1,
							'ajax' => 0,
							'return_format' => 'value',
							'placeholder' => '',
						),
					),
				),
				array(
					'key' => 'field_5c4c84ef08732',
					'label' => 'Remove Pre-assigned Global Sections',
					'name' => 'remove_global_sections',
					'type' => 'select',
					'instructions' => 'Select if you want to remove the global settings already assigned site-wide in Customizer\'s options > General settings > Global Sections. Hold CTRL key to select multiple.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => 'rey-decrease-list-size',
						'id' => '',
					),
					'choices' => array(
					),
					'default_value' => array(
					),
					'allow_null' => 1,
					'multiple' => 1,
					'ui' => 0,
					'return_format' => 'value',
					'ajax' => 0,
					'placeholder' => '',
				),
				array(
					'key' => 'field_5c4ad2d9a592c',
					'label' => 'Redirect',
					'name' => 'general_redirect',
					'type' => 'true_false',
					'instructions' => 'Make this post/page a redirect.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_5c4ad2fea592d',
					'label' => 'Redirect URL',
					'name' => 'redirect_url',
					'type' => 'link',
					'instructions' => 'Enter the URL.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_5c4ad2d9a592c',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'return_format' => 'url',
				),
				array(
					'key' => 'field_5ed770b88a773',
					'label' => 'Sticky Global Section - Top',
					'name' => 'top_sticky_gs',
					'type' => 'select',
					'instructions' => 'Select to add or override the sticky top global section option pre-defined in Customizer > General > Sticky Global Sections',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '--size-3',
						'id' => '',
					),
					'choices' => array(
					),
					'default_value' => false,
					'allow_null' => 1,
					'multiple' => 0,
					'ui' => 0,
					'return_format' => 'value',
					'ajax' => 0,
					'placeholder' => '',
				),
				array(
					'key' => 'field_5ed77352a54b3',
					'label' => 'Activation Offset',
					'name' => 'top_sticky_gs_offset',
					'type' => 'text',
					'instructions' => 'At what distance from the top edge should be displayed. Add value in pixels eg: 100 or 200px etc. or a unique id selector, eg: #my_unique_element . If empty it\'ll be triggered after the site-header exists viewport.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_5ed770b88a773',
								'operator' => '!=',
								'value' => '',
							),
							array(
								'field' => 'field_5ed770b88a773',
								'operator' => '!=',
								'value' => 'none',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '--size-3 --dependent',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'maxlength' => '',
				),
				array(
					'key' => 'field_5ed773c0a54b4',
					'label' => 'Text Color',
					'name' => 'top_sticky_gs_color',
					'type' => 'color_picker',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_5ed770b88a773',
								'operator' => '!=',
								'value' => '',
							),
							array(
								'field' => 'field_5ed770b88a773',
								'operator' => '!=',
								'value' => 'none',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => ' --dependent',
						'id' => '',
					),
					'enable_opacity' => 1,
					'default_value' => '',
				),
				array(
					'key' => 'field_5ed773eca54b5',
					'label' => 'Background Color',
					'name' => 'top_sticky_gs_bg_color',
					'type' => 'color_picker',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_5ed770b88a773',
								'operator' => '!=',
								'value' => '',
							),
							array(
								'field' => 'field_5ed770b88a773',
								'operator' => '!=',
								'value' => 'none',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => ' --dependent',
						'id' => '',
					),
					'enable_opacity' => 1,
					'default_value' => '',
				),
				array(
					'key' => 'field_60e5e45cc8f30',
					'label' => 'Select visibility',
					'name' => 'top_sticky_gs_hide_devices',
					'type' => 'select',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_5ed770b88a773',
								'operator' => '!=',
								'value' => '',
							),
							array(
								'field' => 'field_5ed770b88a773',
								'operator' => '!=',
								'value' => 'none',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => ' --dependent',
						'id' => '',
					),
					'choices' => array(
						'desktop' => 'Hide on desktop',
						'tablet' => 'Hide on tablet',
						'mobile' => 'Hide on mobile',
					),
					'default_value' => array(
					),
					'allow_null' => 1,
					'multiple' => 1,
					'ui' => 1,
					'return_format' => 'value',
					'ajax' => 0,
					'placeholder' => '',
				),
				array(
					'key' => 'field_5ed7747da54b7',
					'label' => 'Add close button?',
					'name' => 'top_sticky_gs_close',
					'type' => 'select',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_5ed770b88a773',
								'operator' => '!=',
								'value' => '',
							),
							array(
								'field' => 'field_5ed770b88a773',
								'operator' => '!=',
								'value' => 'none',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '--size-1 --dependent',
						'id' => '',
					),
					'choices' => array(
						'yes' => 'Yes',
						'no' => 'No',
					),
					'default_value' => false,
					'allow_null' => 1,
					'multiple' => 0,
					'ui' => 0,
					'return_format' => 'value',
					'ajax' => 0,
					'placeholder' => '',
				),
				array(
					'key' => 'field_5ed771438a774',
					'label' => 'Sticky Global Section - Bottom',
					'name' => 'bottom_sticky_gs',
					'type' => 'select',
					'instructions' => 'Select to add or override the sticky top global section option pre-defined in Customizer > General > Sticky Global Sections',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '--size-3',
						'id' => '',
					),
					'choices' => array(
					),
					'default_value' => false,
					'allow_null' => 1,
					'multiple' => 0,
					'ui' => 0,
					'return_format' => 'value',
					'ajax' => 0,
					'placeholder' => '',
				),
				array(
					'key' => 'field_5ed77694922fa',
					'label' => 'Activation Offset',
					'name' => 'bottom_sticky_gs_offset',
					'type' => 'text',
					'instructions' => 'At what distance from the top edge should be displayed. Add value in pixels eg: 100 or 200px etc. or a unique id selector, eg: #my_unique_element . If empty it\'ll be triggered after the site-header exists viewport.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_5ed771438a774',
								'operator' => '!=',
								'value' => '',
							),
							array(
								'field' => 'field_5ed771438a774',
								'operator' => '!=',
								'value' => 'none',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '--size-3 --dependent',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'maxlength' => '',
				),
				array(
					'key' => 'field_6e45f0cc8e530',
					'label' => 'Select visibility',
					'name' => 'bottom_sticky_gs_hide_devices',
					'type' => 'select',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_5ed771438a774',
								'operator' => '!=',
								'value' => '',
							),
							array(
								'field' => 'field_5ed771438a774',
								'operator' => '!=',
								'value' => 'none',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => ' --dependent',
						'id' => '',
					),
					'choices' => array(
						'desktop' => 'Hide on desktop',
						'tablet' => 'Hide on tablet',
						'mobile' => 'Hide on mobile',
					),
					'default_value' => array(
					),
					'allow_null' => 1,
					'multiple' => 1,
					'ui' => 1,
					'return_format' => 'value',
					'ajax' => 0,
					'placeholder' => '',
				),
				array(
					'key' => 'field_5ed776c2922fc',
					'label' => 'Add close button?',
					'name' => 'bottom_sticky_gs_close',
					'type' => 'select',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_5ed771438a774',
								'operator' => '!=',
								'value' => '',
							),
							array(
								'field' => 'field_5ed771438a774',
								'operator' => '!=',
								'value' => 'none',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '--size-1 --dependent',
						'id' => '',
					),
					'choices' => array(
						'yes' => 'Yes',
						'no' => 'No',
					),
					'default_value' => false,
					'allow_null' => 1,
					'multiple' => 0,
					'ui' => 0,
					'return_format' => 'value',
					'ajax' => 0,
					'placeholder' => '',
				),
				array(
					'key' => 'field_6031467caec55',
					'label' => '',
					'name' => '',
					'type' => 'message',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '<h3>Assets</h3>',
					'new_lines' => 'wpautop',
					'esc_html' => 0,
				),
				array(
					'key' => 'field_603146f7aec56',
					'label' => 'Disable WordPress Blocks Styles',
					'name' => 'perf__disable_wpblock',
					'type' => 'select',
					'instructions' => 'Will disable WordPress\'s built-in Gutenberg editor styles. Enable this option if you don\'t use blocks throughout this page.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '--size-1',
						'id' => '',
					),
					'choices' => array(
						1 => 'Yes',
						0 => 'No',
					),
					'default_value' => false,
					'allow_null' => 1,
					'multiple' => 0,
					'ui' => 0,
					'return_format' => 'value',
					'ajax' => 0,
					'placeholder' => '',
				),
				array(
					'key' => 'field_60314765aec57',
					'label' => 'Disable WooCommerce Blocks Styles',
					'name' => 'perf__disable_wcblock',
					'type' => 'select',
					'instructions' => 'Will disable WordPress\'s built-in Gutenberg editor styles. Enable this option if you don\'t use blocks throughout this page.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '--size-1',
						'id' => '',
					),
					'choices' => array(
						1 => 'Yes',
						0 => 'No',
					),
					'default_value' => false,
					'allow_null' => 1,
					'multiple' => 0,
					'ui' => 0,
					'return_format' => 'value',
					'ajax' => 0,
					'placeholder' => '',
				),
				array(
					'key' => 'field_6031477faec58',
					'label' => 'Exclude CSS Stylesheets',
					'name' => 'perf__css_exclude',
					'type' => 'select',
					'instructions' => 'You can choose specific stylesheets to exclude from being loaded globally in the site. Not recommended unless you specifically want this for various purposes such as overrides or things like that. There\'s a global option in Customizer > General > Performance too.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
					),
					'default_value' => array(
					),
					'allow_null' => 1,
					'multiple' => 1,
					'ui' => 1,
					'ajax' => 0,
					'return_format' => 'value',
					'placeholder' => '',
				),
			),
			'location' => array(
			),
			'menu_order' => 0,
			'position' => 'normal',
			'style' => 'default',
			'label_placement' => 'top',
			'instruction_placement' => 'label',
			'hide_on_screen' => '',
			'active' => true,
			'description' => 'These settings apply for this post/page/taxonomies.',

		];
	}

	public function f__theme_settings(){
		return [
			'key' => 'group_5c990a758cfda',
			'title' => 'Theme Settings',
			'fields' => array(
				array(
					'key' => 'field_5d3afdfd482f1',
					'label' => 'Font Settings',
					'name' => '',
					'type' => 'tab',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'placement' => 'top',
					'endpoint' => 0,
				),
				array(
					'key' => 'field_5c9e384a43424',
					'label' => '',
					'name' => '',
					'type' => 'message',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '<h1>Font Settings</h1><p>Adjust your website\'s typography settings. To customize frontend\'s typography, head over to Customizer > General > Typography.</p>',
					'new_lines' => 'wpautop',
					'esc_html' => 0,
				),
				array(
					'key' => 'field_5c99dfa967354',
					'label' => 'Preload Google Fonts',
					'name' => 'preload_google_fonts',
					'type' => 'repeater',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => 'rey-acf-repeater-list rey-acf-repeater-list--fonts',
						'id' => '',
					),
					'collapsed' => 'field_5c99e05667355',
					'min' => 0,
					'max' => 0,
					'layout' => 'table',
					'button_label' => 'Add Google Font',
					'sub_fields' => array(
						array(
							'key' => 'field_5c99e05667355',
							'label' => 'Font name',
							'name' => 'font_name',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
							),
							'default_value' => false,
							'allow_null' => 1,
							'multiple' => 0,
							'ui' => 1,
							'ajax' => 0,
							'return_format' => 'value',
							'placeholder' => '',
						),
						// what to do with Adobe
						// array(
						// 	'key' => 'field_5c99e08356467',
						// 	'label' => 'Hierarchy',
						// 	'name' => 'font_hierarchy',
						// 	'type' => 'select',
						// 	'instructions' => 'Select the font hierarchy for the frontend.',
						// 	'required' => 0,
						// 	'conditional_logic' => array(
						// 		array(
						// 			array(
						// 				'field' => 'field_5c99e05667355',
						// 				'operator' => '!=',
						// 				'value' => '',
						// 			),
						// 		),
						// 	),
						// 	'wrapper' => array(
						// 		'width' => '',
						// 		'class' => '',
						// 		'id' => '',
						// 	),
						// 	'choices' => array(
						// 		'' => '- Generic -',
						// 		'primary' => 'Primary',
						// 		'secondary' => 'Secondary',
						// 	),
						// 	'allow_null' => 1,
						// 	'multiple' => 0,
						// 	'ui' => 1,
						// 	'ajax' => 0,
						// 	'return_format' => 'value',
						// 	'placeholder' => '',
						// ),
						array(
							'key' => 'field_5c99e08467356',
							'label' => 'Font Variants',
							'name' => 'font_variants',
							'type' => 'select',
							'instructions' => 'Select any font variant you want to load.',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5c99e05667355',
										'operator' => '!=',
										'value' => '',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								100 => '100 (Ultra-Light)',
								'100i' => '100 Italic (Ultra-Light)',
								200 => '200 (Light)',
								'200i' => '200 Italic (Light)',
								300 => '300 (Book)',
								'300i' => '300 Italic (Book)',
								400 => '400 (Normal)',
								'400i' => '400 Italic (Normal)',
								500 => '500 (Medium)',
								'500i' => '500 Italic (Medium)',
								600 => '600 (Semi-Bold)',
								'600i' => '600 Italic (Semi-Bold)',
								700 => '700 (Bold)',
								'700i' => '700 Italic (Bold)',
								800 => '800 (Extra-Bold)',
								'800i' => '800 Italic (Extra-Bold)',
								900 => '900 (Ultra-Bold)',
								'900i' => '900 Italic (Ultra-Bold)',
							),
							'default_value' => array(
							),
							'allow_null' => 0,
							'multiple' => 1,
							'ui' => 1,
							'ajax' => 0,
							'return_format' => 'value',
							'placeholder' => '',
						),
						array(
							'key' => 'field_5c9e3e5698733',
							'label' => 'Font Subsets',
							'name' => 'font_subsets',
							'type' => 'select',
							'instructions' => 'Be sure to check Google Fonts app what subsets are supported.',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5c99e05667355',
										'operator' => '!=',
										'value' => '',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'latin-ext' => 'Latin Extended',
								'cyrillic' => 'Cyrillic',
								'cyrillic-ext' => 'Cyrillic Extended',
								'greek' => 'Greek',
								'greek-ext' => 'Greek Extended',
								'hebrew' => 'Hebrew',
								'malayalam' => 'Malayalam',
								'vietnamese' => 'Vietnamese',
								'devanagari' => 'Devanagari',
								'khmer' => 'Khmer',
								'arabic' => 'Arabic',
								'bengali' => 'Bengali',
								'gujarati' => 'Gujarati',
								'tamil' => 'Tamil',
								'telugu' => 'Telugu',
								'thai' => 'Thai',
							),
							'default_value' => array(
							),
							'allow_null' => 1,
							'multiple' => 1,
							'ui' => 1,
							'ajax' => 0,
							'return_format' => 'value',
							'placeholder' => '',
						),
					),
				),
				array(
					'key' => 'field_5c997501aef80',
					'label' => 'Self-host Google Fonts',
					'name' => 'self_host_fonts',
					'type' => 'true_false',
					'instructions' => 'This option will store the Google Fonts on your server, resulting in potentially faster rendering.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_5caf1fa73b466',
					'label' => 'Adobe Fonts Project ID (Typekit)',
					'name' => 'adobe_fonts_project_id',
					'type' => 'text',
					'instructions' => 'Create a new <a href="https://fonts.adobe.com/my_fonts#web_projects-section" target="_blank">Adobe Font Web Project</a> and paste here its project ID. After saving this page, you\'ll be able to notice the new fonts in the fonts lists of Customizer and Elementor.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => 'rey-decrease-list-size',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => 'eg: pa2xijk',
					'prepend' => '',
					'append' => '',
					'maxlength' => 10,
				),

				array(
					'key' => 'field_5ef73f139c0a1',
					'label' => 'Custom Fonts',
					'name' => 'custom_fonts',
					'type' => 'repeater',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '--acf-repeater-row',
						'id' => '',
					),
					'collapsed' => '',
					'min' => 0,
					'max' => 0,
					'layout' => 'table',
					'button_label' => 'Add Custom Font',
					'sub_fields' => array(
						array(
							'key' => 'field_5ef73f449c0a2',
							'label' => 'Name',
							'name' => 'name',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_5ef0a2449f73c',
							'label' => 'Weight',
							'name' => 'weight',
							'type' => 'text',
							'instructions' => 'Variable fonts support multiple weights',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_5ef73f579c0a3',
							'label' => 'Font .woff2',
							'name' => 'font_woff2',
							'type' => 'file',
							'instructions' => 'Upload the font\'s woff2 file.',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'return_format' => 'array',
							'library' => 'all',
							'min_size' => '',
							'max_size' => '',
							'mime_types' => '.woff2',
						),
						array(
							'key' => 'field_5ef73fab9c0a4',
							'label' => 'Font .woff',
							'name' => 'font_woff',
							'type' => 'file',
							'instructions' => 'Upload the font\'s woff file.',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'return_format' => 'array',
							'library' => 'all',
							'min_size' => '',
							'max_size' => '',
							'mime_types' => '.woff',
						),
						array(
							'key' => 'field_5ef73fae9c0a5',
							'label' => 'Font .ttf',
							'name' => 'font_ttf',
							'type' => 'file',
							'instructions' => 'Upload the font\'s ttf file.',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'return_format' => 'array',
							'library' => 'all',
							'min_size' => '',
							'max_size' => '',
							'mime_types' => '.ttf',
						),
						array(
							'key' => 'field_5ef73fbf9c0a8',
							'label' => 'Font .otf',
							'name' => 'font_otf',
							'type' => 'file',
							'instructions' => 'Upload the font\'s otf file.',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'return_format' => 'array',
							'library' => 'all',
							'min_size' => '',
							'max_size' => '',
							'mime_types' => '.otf',
						),
						array(
							'key' => 'field_5ef740139c0a9',
							'label' => 'Font Display',
							'name' => 'font_display',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'auto' => 'Auto',
								'block' => 'Block',
								'swap' => 'Swap',
								'fallback' => 'Fallback',
								'optional' => 'Optional',
							),
							'default_value' => 'auto',
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
					),
				),

				array(
					'key' => 'field_5d3afe12f2648',
					'label' => 'Integrations',
					'name' => '',
					'type' => 'tab',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'placement' => 'top',
					'endpoint' => 0,
				),

				array(
					'key' => 'field_5c9e3a1250024',
					'label' => '',
					'name' => '',
					'type' => 'message',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '<h1>Integration Settings</h1>',
					'new_lines' => 'wpautop',
					'esc_html' => 0,
				),

				array(
					'key' => 'field_5db54e01245bb',
					'label' => 'Instagram Access Token',
					'name' => 'ig_access_token',
					'type' => 'text',
					'instructions' => 'Access Token used for Instagram Image Feeds. Please read <strong><a href="' . reycore__support_url('kb/add-instagram-feeds/#generate-access-tokens') . '" target="_blank">this article</a></strong> to find out how to generate an Instagram Access Token.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => 'example: IGQVJYTGpIVHJyNAsdEhDLUtVZA0wxWG53cHp2UzMUJib3hjcU1YQkE0zTVlkV9uRS1sSzFfX05zOUNES1ArNTRoeXBDOEdScnFJWWZABSE5STE9fS1N0ZAiNHNCM3VXZAkZYM1NmQyYkJB',
					'prepend' => '',
					'append' => '',
					'maxlength' => '',
				),

				array(
					'key' => 'field_5d3afe16482f2',
					'label' => 'Misc. Settings',
					'name' => '',
					'type' => 'tab',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'placement' => 'top',
					'endpoint' => 0,
				),
				array(
					'key' => 'field_5c9e3a0241250',
					'label' => '',
					'name' => '',
					'type' => 'message',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '<h1>Miscellaneous Settings</h1>',
					'new_lines' => 'wpautop',
					'esc_html' => 0,
				),
				array(
					'key' => 'field_5c991011d16cd',
					'label' => 'ACF fields panel',
					'name' => 'acf_fields_panel',
					'type' => 'true_false',
					'instructions' => 'Enable or disable the custom fields panel (ACF Panel) in the WordPress backend menu.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 1,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_5c01d16c1991d',
					'label' => 'Widgets Page - Blocks Layout',
					'name' => 'rey_widgets_blocks_layout',
					'type' => 'true_false',
					'instructions' => 'Enable Widgets page modern WP 5.8+ blocks layout.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_5ebea386f5754',
					'label' => 'Post types support for "Page Settings"',
					'name' => 'singular_settings_support',
					'type' => 'select',
					'instructions' => 'Select on which post types to display the "Page Settings" options block.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'choices' => [],
					'allow_custom' => 0,
					'default_value' => array(),
					'multiple' => 1,
					'ui' => 1,
					'ajax' => 0,
					'return_format' => 'value',
					'placeholder' => '',
				),
				array(
					'key' => 'field_5ebea386f5755',
					'label' => 'Taxonomy support for "Page Settings"',
					'name' => 'singular_settings_support_taxonomy',
					'type' => 'select',
					'instructions' => 'Select on which taxonomy post types to display the "Page Settings" options block.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'choices' => [],
					'allow_custom' => 0,
					'default_value' => [],
					'multiple' => 1,
					'ui' => 1,
					'ajax' => 0,
					'return_format' => 'value',
					'placeholder' => '',
				),
				array(
					'key' => 'field_5f7c4cfd0fff9',
					'label' => 'Page Settings - User Roles',
					'name' => 'singular_settings_support_roles',
					'type' => 'select',
					'instructions' => 'Select allowed user roles to display the Page settings.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => 'rey-decrease-list-size',
						'id' => '',
					),
					'choices' => array(
					),
					'default_value' => 'all',
					'allow_null' => 0,
					'multiple' => 0,
					'ui' => 1,
					'ajax' => 0,
					'return_format' => 'value',
					'placeholder' => '',
				),

			),
			'location' => array(
				array(
					array(
						'param' => 'options_page',
						'operator' => '==',
						'value' => 'rey-settings',
					),
				),
			),
			'menu_order' => 0,
			'position' => 'acf_after_title',
			'style' => 'seamless',
			'label_placement' => 'left',
			'instruction_placement' => 'field',
			'hide_on_screen' => array(
				0 => 'permalink',
				1 => 'the_content',
				2 => 'excerpt',
				3 => 'discussion',
				4 => 'comments',
				5 => 'revisions',
				6 => 'slug',
				7 => 'author',
				8 => 'format',
				9 => 'page_attributes',
				10 => 'featured_image',
				11 => 'categories',
				12 => 'tags',
				13 => 'send-trackbacks',
			),
			'active' => true,
			'description' => '',

		];
	}

	public function f__icon_menu_settings(){
		return [
			'key' => 'group_5f0439874af42',
			'title' => 'Icon Menu Settings',
			'fields' => array(
				array(
					'key' => 'field_5f04398752b45',
					'label' => 'Menu item Icon',
					'name' => 'enable_menu_item_icon',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_5f04398752b4c',
					'label' => 'Select Icon',
					'name' => 'menu_item_icon',
					'type' => 'image',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_5f04398752b45',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '--dependent',
						'id' => '',
					),
					'return_format' => 'id',
					'preview_size' => 'thumbnail',
					'library' => 'all',
					'min_width' => '',
					'min_height' => '',
					'min_size' => '',
					'max_width' => '',
					'max_height' => '',
					'max_size' => '',
					'mime_types' => '',
				),
			),
			'location' => array(
				array(
					array(
						'param' => 'nav_menu_item',
						'operator' => '==',
						'value' => 'all',
					),
				),
			),
			'menu_order' => 10,
			'position' => 'normal',
			'style' => 'default',
			'label_placement' => 'top',
			'instruction_placement' => 'label',
			'hide_on_screen' => '',
			'active' => true,
			'description' => '',

		];
	}

}

new Fields();
