<?php
namespace ReyCore\ACF;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

use ReyCore\Plugin;

class Helper {

	public static $default_supported_singular_post_types = [];

	public function __construct(){

	}

	/**
	 * Check if is exporting
	 *
	 * @since 1.6.10
	 **/
	public static function is_exporting()
	{
		if( isset($_REQUEST['page']) && $_REQUEST['page'] === 'acf-tools' && isset($_REQUEST['tool']) && $_REQUEST['tool'] === 'export' ){
			return true;
		}
		if( isset($_REQUEST['page']) && $_REQUEST['page'] === 'acf-tools' && isset($_REQUEST['action']) && $_REQUEST['action'] === 'download' ){
			return true;
		}
		return false;
	}

	/**
	 * Check if editing group
	 *
	 * @since 1.6.10
	 **/
	public static function is_editing_group()
	{
		return (get_post_type() === 'acf-field-group' && isset($_REQUEST['action']) && $_REQUEST['action'] === 'edit') ||
			(isset($_REQUEST['page']) && $_REQUEST['page'] === 'acf-tools');
	}

	/**
	 * Check if editing group
	 *
	 * @since 1.7.3
	 **/
	public static function prevent_export_dynamic_field() {
		return self::is_exporting() || self::is_editing_group();
	}

	/**
	 * ACF Image ID to ELementor Media control ID & URL
	 *
	 * @since 1.0.0
	 **/
	public static function image_to_elementor_image( $image_id )
	{
		$url = '';

		if( $image_id ){
			$url_array = wp_get_attachment_image_src( absint( $image_id ), 'full' );
			if( isset($url_array[0]) ){
				$url = $url_array[0];
			}
		}

		return [
			'url' => $url,
			'id' => $image_id ? absint( $image_id ) : ''
		];
	}

	/**
	 * Populate ACF's supported post types for Page Settings
	 *
	 * @since 1.6.6
	 */
	public static function default_supported_singular_post_types( $t = '' ){

		if( empty( self::$default_supported_singular_post_types ) ){

			$types = [
				'post_type' => [ 'post', 'page', 'product', 'rey-templates' ],
				'taxonomy' => [ 'category', 'product_cat', 'product_tag', 'pa_brand' ],
			];

			// automatically add product attributes which are public
			if( function_exists('wc_get_attribute_taxonomies') ):
				foreach ( wc_get_attribute_taxonomies() as $attribute ) {
					if( (bool) $attribute->attribute_public ){
						if( ($attr_name = wc_attribute_taxonomy_name($attribute->attribute_name)) && ! in_array($attr_name, $types['taxonomy'], true) ){
							$types['taxonomy'][] = $attr_name;
						}
					}
				}
			endif;

			self::$default_supported_singular_post_types = $types;

		}
		else {
			$types = self::$default_supported_singular_post_types;
		}

		if( isset($types[$t]) ){
			return $types[$t];
		}

		return $types;
	}

	public static function get_container_padding_placeholders( $edge = 'top' ){

		$prop = 'padding-';

		$defaults = [
			'top' => '50',
			'bottom' => '90',
		];

		if( ($cp = get_theme_mod('content_padding')) ){
			if( isset( $cp[ $prop . $edge ] ) && ($cp_edge = $cp[ $prop . $edge]) ){
				return $cp_edge;
			}
		}

		return $defaults[ $edge ];
	}
}
