<?php
namespace ReyCore\Elementor\Custom;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

class Container {

	function __construct(){
		add_action( 'elementor/frontend/container/before_render', [$this, 'before_render']);
		add_action( 'elementor/frontend/container/after_render', [$this, 'after_render']);
		add_action( 'elementor/element/container/_section_responsive/after_section_end', [$this, 'custom_css_settings']);
		add_action( 'elementor/element/container/section_layout_additional_options/before_section_end', [$this, 'offset_for_mobile']);
		add_action( 'elementor/element/container/section_layout/before_section_end', [$this, 'section_layout_settings']);
		add_filter( 'elementor/frontend/container/should_render', ['\ReyCore\Elementor\WidgetsOverrides', 'should_render_section_or_container'], 10, 2 );
	}


	/**
	* Render some attributes before rendering
	*
	* @since 1.0.0
	**/
	function before_render( $element )
	{

		if( ! apply_filters( "elementor/frontend/container/should_render", true, $element ) ){
			return;
		}

		$element_id = $element->get_id();

		do_action('reycore/frontend/container/before_render', $element);

		$this->should_render[$element_id] = true;

	}

	/**
	* Add HTML after container rendering
	*
	* @since 1.0.0
	**/
	function after_render( $element )
	{

		$element_id = $element->get_id();

		if( ! isset($this->should_render[$element_id]) ){
			return;
		}

		if( ! $this->should_render[$element_id] ){
			return;
		}

		do_action('reycore/frontend/container/after_render', $element);

	}

	public function custom_css_settings( $element ){
		\ReyCore\Elementor\WidgetsOverrides::custom_css_controls($element);
	}

	public function section_layout_settings( $element ){

		$controls_manager = \Elementor\Plugin::instance()->controls_manager;
		$unique_name = $element->get_unique_name();

		// Update margin's placeholder
		$margin_control = \Elementor\Plugin::instance()->controls_manager->get_control_from_stack( $unique_name, 'margin' );
		$container_spacing = get_theme_mod('container_spacing', 15);
		$margin_control['placeholder']['left'] = $container_spacing;
		$margin_control['placeholder']['right'] = $container_spacing;
		$element->update_control( 'margin', $margin_control );

		// Zindex
		$z_index = $controls_manager->get_control_from_stack( $unique_name, 'z_index' );
		$z_index['prefix_class'] = '--zindexed-';
		$element->update_control( 'z_index', $z_index );

		// "Hide On" Selector
		\ReyCore\Elementor\WidgetsOverrides::hide_element_on($element);
	}

	public function offset_for_mobile( $element ){
		// Horizontal Mobile Offset
		\ReyCore\Elementor\WidgetsOverrides::horizontal_offset_for_mobile(
			$element ,
			esc_html__('Only works with an inner Container, set as Row.', 'rey-core')
		);
	}


}
