<?php
namespace ReyCore\Elementor\Custom;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

class Sidebar {

	function __construct(){
		add_action( 'elementor/element/sidebar/section_sidebar/before_section_end', [$this, 'modify_controls'], 10);
	}

	function modify_controls( $element )
	{
		$type_control = \Elementor\Plugin::instance()->controls_manager->get_control_from_stack( $element->get_unique_name(), 'sidebar' );
		$type_control['prefix_class'] = 'widget-area ';
		$element->update_control( 'sidebar', $type_control );
	}

}
