<?php
namespace ReyCore\Elementor\Widgets;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if( ! class_exists('\ReyCore\Modules\Cards\CardElement')){
	return;
}

class Grid extends \ReyCore\Modules\Cards\CardElement {

	public $_settings = [];

	public $_items = [];

	public static function get_rey_config(){
		return [
			'id' => 'grid',
			'title' => __( 'Grid', 'rey-core' ),
			'icon' => 'eicon-gallery-grid',
			'categories' => [ 'rey-theme' ],
			'keywords' => ['list', 'cards', 'posts', 'gallery', 'categories', 'portfolio'],
			'css' => [
				'assets/style[rtl].css',
			],
			'js' => [
				'assets/script.js',
			],
		];
	}

	public function rey_get_script_depends() {
		return [ 'reycore-widget-grid-scripts' ];
	}

	public function get_custom_help_url() {
		return reycore__support_url('kb/rey-elements/#grid');
	}

	public function add_element_controls() {

		$this->selectors['grid'] = '{{WRAPPER}} .rey-gridEl';

		$this->controls__content();
		$this->controls__images();
		$this->controls__custom_content();
		$this->controls__post_query();
		$this->controls__product_cat_query();
		$this->controls__grid_settings();
		$this->controls__content_styles();
		$this->controls__media_styles();
		$this->controls__title_styles();
		$this->controls__subtitle_styles();
		$this->controls__label_styles();
		$this->controls__button_styles();
	}

	public function controls__grid_settings(){

		$this->start_controls_section(
			'section_grid_settings',
			[
				'label' => __( 'Grid Settings', 'rey-core' ),
			]
		);

		$this->add_responsive_control(
			'grid_type',
			[
				'label' => esc_html__( 'Grid Type', 'rey-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'normal',
				'options' => [
					'normal'  => esc_html__( 'Normal', 'rey-core' ),
					'list'  => esc_html__( 'Horizontal List', 'rey-core' ),
					'vlist'  => esc_html__( 'Vertical List', 'rey-core' ),
				],
			]
		);

		$this->add_responsive_control(
			'per_row',
			[
				'label' => __( 'Items Per Row', 'rey-core' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'default' => 4,
				'min' => 1,
				'max' => 12,
				'step' => 1,
				'selectors' => [
					$this->selectors['grid'] => '--per-row: {{VALUE}}',
				],
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'desktop_default' => 4,
				'tablet_default' => 2,
				'mobile_default' => 1,
			]
		);

		$this->add_responsive_control(
			'gap',
			[
				'label' => __( 'Gap', 'rey-core' ) . ' (px)',
				'type' => \Elementor\Controls_Manager::NUMBER,
				'default' => '',
				'min' => 0,
				'max' => 200,
				'step' => 1,
				'selectors' => [
					$this->selectors['grid'] => '--gap: {{VALUE}}px;',
				],
			]
		);

		$this->add_responsive_control(
			'vgap',
			[
				'label' => __( 'Vertical Gap', 'rey-core' ) . ' (px)',
				'type' => \Elementor\Controls_Manager::NUMBER,
				'default' => '',
				'min' => 0,
				'max' => 200,
				'step' => 1,
				'selectors' => [
					$this->selectors['grid'] => '--vgap: {{VALUE}}px;',
				],
				'condition' => [
					'grid_type' => ['normal', 'vlist'],
				],
			]
		);

		$this->add_responsive_control(
			'offset',
			[
				'label' => __( 'Offset', 'rey-core' ) . ' (px)',
				'type' => \Elementor\Controls_Manager::NUMBER,
				'default' => '',
				'min' => 0,
				'max' => 300,
				'step' => 1,
				'selectors' => [
					$this->selectors['grid'] => '--offset: {{VALUE}}px;',
				],
				'condition' => [
					'grid_type' => 'list',
				],
			]
		);

		$this->add_control(
			'enable_drag',
			[
				'label' => esc_html__( 'Enable Drag (desktop)', 'rey-core' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => '',
				'condition' => [
					'grid_type' => 'list',
				],
			]
		);

		$this->end_controls_section();

	}

	public function render_start(){

		$classes = [
			'rey-gridEl',
			'--' . $this->_settings['source'],
		];

		$desktop = $this->_settings[ 'grid_type' ];
		$classes[ 'grid_type' ] = sprintf('--type-%s', $desktop);

		$tablet = isset($this->_settings[ 'grid_type_tablet' ]) ? $this->_settings[ 'grid_type_tablet' ] : $desktop;
		$classes[ 'grid_type_tablet' ] = sprintf('--type-%s-%s', 'md', $tablet );

		$mobile = isset($this->_settings[ 'grid_type_mobile' ]) ? $this->_settings[ 'grid_type_mobile' ] : $tablet;
		$classes[ 'grid_type_mobile' ] = sprintf('--type-%s-%s', 'sm', $mobile );

		$this->add_render_attribute( 'wrapper', 'class', $classes );

		$this->add_render_attribute( 'wrapper', 'style', '--total:' . count($this->_items) );

		?><div <?php echo $this->get_render_attribute_string( 'wrapper' ); ?>><?php
	}

	public function render_end(){
		?></div><?php
	}

	public function render_grid(){

		if( empty($this->_items) ){
			return;
		} ?>

		<div class="__items <?php echo $this->_settings[ 'enable_drag' ] !== ''  && $this->_settings[ 'grid_type' ] === 'list' ? 'js-horizontal-drag' : '' ?>">
			<?php
			for ($i=0; $i < count($this->_items); $i++) {
				$this->item_key = $i;

				$this->parse_item();
				$this->render_item__start();
				$this->render_item();
				$this->render_item__end();

			} ?>
		</div>
		<?php
	}

	public function render_item__start(){

		$classes = [
			'item' => '__item',
		];

		if( isset($this->_items[$this->item_key]['_id']) && $_id = $this->_items[$this->item_key]['_id'] ){
			$classes['_id'] = 'elementor-repeater-item-' . $_id;
		}

		?><div class="<?php echo esc_attr(implode(' ', $classes)) ?>"><?php
	}

	public function render_item__end(){
		?></div><?php
	}


	public function render() {

		reyCoreAssets()->add_styles(['reycore-widget-grid-styles']);

		$this->_settings = $this->get_settings_for_display();
		$this->_items = $this->get_items_data();

		if( $this->_settings[ 'enable_drag' ] !== '' && $this->_settings[ 'grid_type' ] === 'list' ){
			reyCoreAssets()->add_scripts( 'rey-horizontal-drag' );
		}

		$this->render_start();
		$this->render_grid();
		$this->render_end();
	}

}
