<?php
if (!defined('ABSPATH')) exit; // Exit if accessed directly

// Load raw icons
add_action('rey/svg_icons', function($themeSvg){

	// glue all icons
	$themeSvg::$icons = array_merge($themeSvg::$icons, reycore__svg_icons_raw());

	$themeSvg::$social_icons = array_merge($themeSvg::$social_icons, reycore__social_icons_raw());

});

add_action( 'reycore/ajax/register_actions', function ( $ajax_manager ){
	$ajax_manager->register_ajax_action( 'get_svg_icon', function($data){

		if( ! isset($data['id']) ){
			return ['errors' => ['No icon specified.']];
		}

		if( ! (($icon = reycore__clean($data['id'])) && strlen($icon) < 20) ){
			exit;
		}

		return reycore__get_svg_icon(['id' => $icon]);
	}, [
		'auth'  => 3,
		'nonce' => false,
		'transient' => MONTH_IN_SECONDS,
	] );
} );

if(!function_exists('reycore__get_svg_icon')):
	/**
	 * Wrapper for Rey Theme's rey__get_svg_icon()
	 *
	 * @since 1.0.0
	 */
	function reycore__get_svg_icon( $args = [] ) {
		if( function_exists('rey__get_svg_icon') ){
			return rey__get_svg_icon( $args );
		}
		return false;
	}
endif;


if(!function_exists('reycore__get_svg_social_icon')):
	/**
	 * Wrapper for Rey Theme's rey__get_svg_icon()
	 * with the addition of using the social icons.
	 *
	 * @since 1.0.0
	 */
	function reycore__get_svg_social_icon( $args = [] ) {
		return reycore__get_svg_icon( array_merge($args, ['social' => true]) );
	}
endif;

if(!function_exists('reycore__svg_icons_raw')):
	/**
	 * Icons List RAW
	 *
	 * @since 2.4.0
	 **/
	function reycore__svg_icons_raw()
	{

		$icons['heart'] = [
			'icon' => '<path fill="var(--icon-fill, none)" stroke="currentColor" stroke-width="var(--stroke-width, 2px)" stroke-linecap="round" stroke-linejoin="round" d="M20.84 4.61a5.5 5.5 0 0 0-7.78 0L12 5.67l-1.06-1.06a5.5 5.5 0 0 0-7.78 7.78l1.06 1.06L12 21.23l7.78-7.78 1.06-1.06a5.5 5.5 0 0 0 0-7.78z"/>',
			'viewbox' => '0 0 24 24',
		];

		$icons['heart-filled'] = [
			'icon' => '<path fill="currentColor" height="24" stroke="none" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20.84 4.61a5.5 5.5 0 0 0-7.78 0L12 5.67l-1.06-1.06a5.5 5.5 0 0 0-7.78 7.78l1.06 1.06L12 21.23l7.78-7.78 1.06-1.06a5.5 5.5 0 0 0 0-7.78z"/>',
			'viewbox' => '0 0 24 24',
		];

		$icons['downloaded'] = [
			'icon' => '<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
            <path d="M8,12 C7.7,12 7.5,11.9 7.3,11.7 L1.6,6 L3,4.6 L7,8.6 L7,0 L9,0 L9,8.6 L13,4.6 L14.4,6 L8.7,11.7 C8.5,11.9 8.3,12 8,12 Z M14,14 L14,11 L16,11 L16,15 C16,15.6 15.6,16 15,16 L1,16 C0.4,16 0,15.6 0,15 L0,11 L2,11 L2,14 L14,14 Z" fill="currentColor" fill-rule="nonzero"></path></g>',
			'viewbox' => '0 0 16 16',
		];

		$icons['favorites'] = [
			'icon' => '<polygon points="53 112.84632 3 142.84632 3 3 103 3 103 142.84632"  fill="var(--icon-fill, none)" stroke="currentColor" stroke-width="var(--stroke-width, 5px)"></polygon>',
			'viewbox' => '0 0 106 147',
		];

		$icons['grid'] = [
			'icon' => '<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
            <path d="M3,0 L11.84,0 C13.4968542,0 14.84,1.34314575 14.84,3 L14.84,11.844 C14.84,13.5008542 13.4968542,14.844 11.84,14.844 L3,14.844 C1.34314575,14.844 -4.54747351e-13,13.5008542 -4.54747351e-13,11.844 L-4.54747351e-13,3 C-4.54747351e-13,1.34314575 1.34314575,0 3,0 L3,0 Z M21.16,0 L30,0 C31.6568542,0 33,1.34314575 33,3 L33,11.844 C33,13.5008542 31.6568542,14.844 30,14.844 L21.16,14.844 C19.5031458,14.844 18.16,13.5008542 18.16,11.844 L18.16,3 C18.16,1.34314575 19.5031458,0 21.16,0 L21.16,0 Z M3,18.156 L11.84,18.156 C13.4968542,18.156 14.84,19.4991458 14.84,21.156 L14.84,30 C14.84,31.6568542 13.4968542,33 11.84,33 L3,33 C1.34314575,33 -4.54747351e-13,31.6568542 -4.54747351e-13,30 L-4.54747351e-13,21.156 C-4.54747351e-13,19.4991458 1.34314575,18.156 3,18.156 L3,18.156 Z M21.16,18.156 L30,18.156 C31.6568542,18.156 33,19.4991458 33,21.156 L33,30 C33,31.6568542 31.6568542,33 30,33 L21.16,33 C19.5031458,33 18.16,31.6568542 18.16,30 L18.16,21.156 C18.16,19.4991458 19.5031458,18.156 21.16,18.156 L21.16,18.156 Z" fill="currentColor"></path></g>',
			'viewbox' => '0 0 33 33',
		];

		$icons['arrow'] = [
			'icon' => '<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
            <polygon fill="currentColor" points="-0.01 2.44 10.99 13.073 21.98 2.44 19.5 0.008 10.99 8.243 2.47 0.008"></polygon></g>',
			'viewbox' => '0 0 22 13',
		];

		$icons['external-link'] = [
			'icon' => '<g fill="currentColor" fill-rule="nonzero">
            <path d="M826.404,497.163805 C826.404,542.080805 826.404,586.996805 826.404,631.913805 C826.404,661.911805 826.404,691.909805 826.404,721.906805 C826.404,737.873805 827.371,754.295805 825.718,770.213805 C825.617,771.126805 825.505,772.038805 825.383,772.949805 C825.916,769.096805 826.449,765.244805 826.983,761.391805 C825.597,771.232805 823.008,780.771805 819.218,789.957805 C820.697,786.418805 822.178,782.879805 823.657,779.339805 C819.847,788.273805 814.999,796.628805 809.14,804.374805 C811.466,801.322805 813.791,798.271805 816.117,795.220805 C810.211,802.846805 803.463,809.671805 795.906,815.665805 C798.975,813.276805 802.046,810.889805 805.115,808.501805 C797.09,814.717805 788.382,819.838805 779.044,823.820805 C782.757,822.270805 786.47,820.720805 790.183,819.171805 C780.995,822.962805 771.457,825.550805 761.616,826.937805 C765.607,826.422805 769.597,825.908805 773.588,825.393805 C763.081,826.743805 752.451,826.414805 741.881,826.414805 C724.618,826.414805 707.357,826.414805 690.095,826.414805 C633.102,826.414805 576.11,826.414805 519.117,826.414805 C454.097,826.414805 389.078,826.414805 324.059,826.414805 C277.33,826.414805 230.601,826.414805 183.873,826.414805 C170.501,826.414805 156.772,827.101805 143.485,825.393805 C147.338,825.926805 151.19,826.459805 155.043,826.993805 C145.201,825.607805 135.663,823.018805 126.476,819.228805 C130.016,820.707805 133.555,822.188805 137.094,823.667805 C128.161,819.857805 119.805,815.009805 112.06,809.150805 C115.111,811.475805 118.163,813.800805 121.214,816.126805 C113.589,810.220805 106.763,803.473805 100.769,795.915805 C103.157,798.985805 105.545,802.055805 107.933,805.125805 C101.717,797.099805 96.596,788.392805 92.614,779.054805 C94.164,782.767805 95.713,786.480805 97.263,790.193805 C93.472,781.005805 90.884,771.467805 89.498,761.626805 C90.013,765.616805 90.527,769.607805 91.041,773.598805 C89.691,763.091805 90.021,752.461805 90.021,741.890805 C90.021,724.628805 90.021,707.367805 90.021,690.105805 C90.021,633.112805 90.021,576.120805 90.021,519.127805 C90.021,454.107805 90.021,389.088805 90.021,324.068805 C90.021,277.339805 90.021,230.610805 90.021,183.882805 C90.021,170.510805 89.334,156.781805 91.041,143.494805 C90.508,147.347805 89.975,151.199805 89.441,155.052805 C90.827,145.210805 93.415,135.672805 97.206,126.485805 C95.726,130.025805 94.247,133.564805 92.767,137.103805 C96.577,128.170805 101.426,119.814805 107.283,112.069805 C104.958,115.120805 102.633,118.172805 100.307,121.223805 C106.213,113.598805 112.961,106.772805 120.518,100.778805 C117.448,103.166805 114.378,105.554805 111.309,107.942805 C119.335,101.726805 128.042,96.605805 137.38,92.623805 C133.667,94.173805 129.954,95.722805 126.241,97.272805 C135.429,93.481805 144.967,90.893805 154.808,89.507805 C150.818,90.022805 146.828,90.536805 142.837,91.050805 C159.172,88.951805 176.204,90.030805 192.626,90.030805 C222.477,90.030805 252.329,90.030805 282.18,90.030805 C326.86,90.030805 371.54,90.030805 416.221,90.030805 C440.736,90.030805 461.392,69.980805 461.555,45.344805 C461.717,20.952805 441.386,0.0108050348 416.869,0.0108050348 C371.857,0.0108050348 326.844,0.0108050348 281.831,0.0108050348 C252.078,0.0108050348 222.325,0.0108050348 192.572,0.0108050348 C171.952,0.0108050348 152.016,-0.312194965 131.514,2.57380503 C102.138,6.71080503 75.985,21.235805 53.475,39.949805 C31.389,58.310805 16.079,84.492805 7.132,111.478805 C0.937,130.159805 0,149.829805 0,169.317805 C0,209.595805 0,249.874805 0,290.151805 C0,353.720805 0,417.290805 0,480.859805 C0,541.401805 0,601.944805 0,662.487805 C0,693.685805 0,724.884805 0,756.083805 C0,800.048805 17.575,843.213805 49.884,873.370805 C79.974,901.457805 119.58,916.433805 160.616,916.433805 C193.286,916.433805 225.956,916.433805 258.627,916.433805 C319.72,916.433805 380.813,916.433805 441.906,916.433805 C505.105,916.433805 568.303,916.433805 631.501,916.433805 C670.487,916.433805 709.474,916.433805 748.46,916.433805 C770.537,916.433805 792.868,914.608805 813.477,906.105805 C821.746,902.694805 829.888,899.417805 837.641,894.976805 C845.582,890.427805 852.75,884.641805 859.897,878.973805 C871.32,869.912805 880.012,858.977805 888.655,847.272805 C906.008,823.770805 914.277,794.141805 916.211,765.332805 C917.227,750.204805 916.424,734.799805 916.424,719.657805 C916.424,689.293805 916.424,658.928805 916.424,628.565805 C916.424,584.980805 916.424,541.396805 916.424,497.811805 C916.424,473.296805 896.374,452.640805 871.738,452.477805 C847.346,452.315805 826.404,472.646805 826.404,497.163805 L826.404,497.163805 Z" id="Path"></path> <path d="M582.373,90.030805 C624.85,90.069805 667.326,90.108805 709.803,90.147805 C761.886,90.195805 813.969,90.243805 866.052,90.291805 C867.731,90.293805 869.41,90.294805 871.09,90.296805 C895.605,90.318805 916.261,70.229805 916.424,45.610805 C916.586,21.201805 896.255,0.298805035 871.738,0.276805035 C829.261,0.237805035 786.785,0.198805035 744.308,0.159805035 C692.225,0.111805035 640.142,0.0638050348 588.059,0.0158050348 C586.38,0.0138050348 584.701,0.0128050348 583.021,0.0108050348 C558.506,-0.0111949652 537.85,20.077805 537.687,44.696805 C537.525,69.104805 557.856,90.008805 582.373,90.030805 L582.373,90.030805 Z" id="Path"></path>
            <path d="M916.157,334.063805 C916.197,291.586805 916.236,249.110805 916.275,206.633805 C916.323,154.550805 916.371,102.466805 916.42,50.383805 C916.421,48.703805 916.423,47.024805 916.424,45.344805 C916.447,20.829805 896.358,0.173805035 871.738,0.0108050348 C847.329,-0.151194965 826.426,20.180805 826.404,44.696805 C826.364,87.173805 826.325,129.649805 826.286,172.126805 C826.238,224.209805 826.19,276.293805 826.141,328.376805 C826.14,330.056805 826.138,331.735805 826.137,333.415805 C826.114,357.930805 846.203,378.586805 870.823,378.749805 C895.232,378.911805 916.134,358.579805 916.157,334.063805 L916.157,334.063805 Z" id="Path"></path>
            <path d="M435.12,544.588805 C451.566,528.154805 468.012,511.722805 484.458,495.289805 C523.593,456.186805 562.727,417.083805 601.861,377.979805 C648.381,331.498805 694.899,285.016805 741.419,238.534805 C780.018,199.966805 818.616,161.398805 857.216,122.830805 C872.613,107.444805 888.012,92.059805 903.409,76.673805 C920.733,59.362805 920.44,30.179805 903.068,13.024805 C885.555,-4.26719497 856.777,-3.97819497 839.419,13.365805 C822.973,29.798805 806.527,46.230805 790.081,62.663805 C750.946,101.767805 711.812,140.870805 672.678,179.973805 C626.158,226.454805 579.64,272.936805 533.12,319.418805 C494.521,357.986805 455.922,396.554805 417.324,435.122805 C401.926,450.508805 386.528,465.893805 371.13,481.278805 C353.806,498.589805 354.099,527.772805 371.471,544.927805 C388.982,562.221805 417.761,561.932805 435.12,544.588805 L435.12,544.588805 Z" id="Path"></path></g>',
			'viewbox' => '0 0 917 917',
		];

		$icons['sync'] = [
			'icon' => '<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
            <path d="M13,7 C12.391,7 12.102,7.43 12,7.883 C11.635,9.516 10.084,12 7,12 C6.243,12 5.527,11.828 4.886,11.526 L5.414,11 C5.773,10.656 6,10.445 6,10 C6,9.477 5.562,9 5,9 L2,9 C1.391,9 1,9.492 1,10 L1,13 C1,13.541 1.428,14 2,14 C2.484,14 2.688,13.727 3,13.406 L3.408,12.999 C4.458,13.632 5.685,14 7,14 C11.99,14 14,9.25 14,8.062 C14,7.336 13.469,7 13,7 Z M2,6.117 C2.365,4.485 3.916,2 7,2 C7.757,2 8.473,2.171 9.114,2.473 L8.586,3 C8.227,3.344 8,3.555 8,4 C8,4.523 8.438,5 9,5 L12,5 C12.609,5 13,4.508 13,4 L13,1 C13,0.459 12.572,0 12,0 C11.516,0 11.312,0.273 11,0.594 L10.592,1.001 C9.542,0.368 8.315,0 7,0 C2.01,0 0,4.75 0,5.938 C0,6.664 0.531,7 1,7 C1.609,7 1.898,6.57 2,6.117 Z" fill="currentColor" fill-rule="nonzero"></path></g>',
			'viewbox' => '0 0 14 14',
		];

		$icons['eye'] = [
			'icon' => '<g fill="currentColor">
            <path d="M231,346 C361.436183,346 462,200.328259 462,173 C462,140.487458 358.577777,0 231,0 C93.5440287,0 -9.09494702e-13,147.592833 0,173 C-9.09494702e-13,202.891659 98.7537165,346 231,346 Z M56.5824289,160.219944 C66.7713209,143.972119 80.8380648,126.358481 96.9838655,110.409249 C137.421767,70.4636625 183.742247,47 231,47 C274.601338,47 320.969689,69.950087 362.198255,108.597753 C379.196924,124.532309 394.05286,142.102205 404.598894,158.109745 C408.097652,163.420414 410.921082,168.270183 412.937184,172.308999 C410.938053,176.17267 408.227675,180.777961 404.935744,185.802242 C394.313487,202.014365 379.591292,219.766541 362.844874,235.861815 C321.537134,275.563401 275.324602,299 231,299 C185.594631,299 139.232036,275.892241 98.4322564,236.780777 C81.8396065,220.874739 67.3726628,203.315324 57.0346413,187.230288 C53.7287772,182.08666 51.0347693,177.372655 49.078323,173.422728 C50.9746819,169.614712 53.5157275,165.110292 56.5824289,160.219944 Z" fill-rule="nonzero"></path> <circle id="Oval" cx="231" cy="173" r="51"></circle></g>',
			'viewbox' => '0 0 462 346',
		];

		$icons['compare'] = [
			'icon' => '<g  stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
            <g id="Group" fill="currentColor" fill-rule="nonzero">
                <path d="M68.8,265.5 C91.1,243.2 113.4,220.9 135.8,198.5 C171.1,163.2 206.3,128 241.6,92.7 C249.7,84.6 257.8,76.5 265.9,68.4 C247,68.4 228.2,68.4 209.3,68.4 C231.6,90.7 253.9,113 276.3,135.4 C311.6,170.7 346.8,205.9 382.1,241.2 C390.2,249.3 398.3,257.4 406.4,265.5 C421.2,280.3 448.4,281.4 463,265.5 C477.7,249.5 478.8,224.7 463,208.9 C440.7,186.6 418.4,164.3 396,141.9 C360.7,106.6 325.5,71.4 290.2,36.1 C282.1,28 274,19.9 265.9,11.8 C250.6,-3.5 224.6,-3.5 209.3,11.8 C187,34.1 164.7,56.4 142.3,78.8 C107.1,114 71.9,149.3 36.6,184.6 C28.5,192.7 20.4,200.8 12.3,208.9 C-2.5,223.7 -3.6,250.9 12.3,265.5 C28.2,280.1 53,281.3 68.8,265.5 L68.8,265.5 Z" id="Path"></path>
                <path d="M197.7,40.1 C197.7,46.6 197.7,53.1 197.7,59.6 C197.7,77.4 197.7,95.2 197.7,113 C197.7,139.2 197.7,165.4 197.7,191.6 C197.7,223.7 197.7,255.8 197.7,288 C197.7,323 197.7,358 197.7,393.1 C197.7,428.5 197.7,463.8 197.7,499.2 C197.7,532.2 197.7,565.1 197.7,598.1 C197.7,626.1 197.7,654.1 197.7,682.1 C197.7,702.1 197.7,722.2 197.7,742.2 C197.7,751.7 197.6,761.3 197.7,770.8 C197.7,771.2 197.7,771.6 197.7,772 C197.7,792.9 216.1,813 237.7,812 C259.4,811 277.7,794.4 277.7,772 C277.7,765.5 277.7,759 277.7,752.5 C277.7,734.7 277.7,716.9 277.7,699.1 C277.7,672.9 277.7,646.7 277.7,620.5 C277.7,588.4 277.7,556.3 277.7,524.1 C277.7,489.1 277.7,454.1 277.7,419 C277.7,383.6 277.7,348.3 277.7,312.9 C277.7,279.9 277.7,247 277.7,214 C277.7,186 277.7,158 277.7,130 C277.7,110 277.7,89.9 277.7,69.9 C277.7,60.4 277.8,50.8 277.7,41.3 C277.7,40.9 277.7,40.5 277.7,40.1 C277.7,19.2 259.3,-0.9 237.7,0.1 C216,1.1 197.7,17.7 197.7,40.1 L197.7,40.1 Z" id="Path"></path>
                <path d="M521,763.1 C543.3,785.4 565.6,807.7 588,830.1 C623.3,865.4 658.5,900.6 693.8,935.9 C701.9,944 710,952.1 718.1,960.2 C733.4,975.5 759.4,975.5 774.7,960.2 C797,937.9 819.3,915.6 841.7,893.2 C877,857.9 912.2,822.7 947.5,787.4 C955.6,779.3 963.7,771.2 971.8,763.1 C986.6,748.3 987.7,721.1 971.8,706.5 C955.8,691.8 931,690.7 915.2,706.5 C892.9,728.8 870.6,751.1 848.2,773.5 C812.9,808.8 777.7,844 742.4,879.3 C734.3,887.4 726.2,895.5 718.1,903.6 C737,903.6 755.8,903.6 774.7,903.6 C752.4,881.3 730.1,859 707.7,836.6 C672.4,801.3 637.2,766.1 601.9,730.8 C593.8,722.7 585.7,714.6 577.6,706.5 C562.8,691.7 535.6,690.6 521,706.5 C506.3,722.5 505.1,747.3 521,763.1 L521,763.1 Z" id="Path"></path>
                <path d="M786.3,931.9 C786.3,925.4 786.3,918.9 786.3,912.4 C786.3,894.6 786.3,876.8 786.3,859 C786.3,832.8 786.3,806.6 786.3,780.4 C786.3,748.3 786.3,716.2 786.3,684 C786.3,649 786.3,614 786.3,578.9 C786.3,543.5 786.3,508.2 786.3,472.8 C786.3,439.8 786.3,406.9 786.3,373.9 C786.3,345.9 786.3,317.9 786.3,289.9 C786.3,269.9 786.3,249.8 786.3,229.8 C786.3,220.3 786.4,210.7 786.3,201.2 C786.3,200.8 786.3,200.4 786.3,200 C786.3,179.1 767.9,159 746.3,160 C724.6,161 706.3,177.6 706.3,200 C706.3,206.5 706.3,213 706.3,219.5 C706.3,237.3 706.3,255.1 706.3,272.9 C706.3,299.1 706.3,325.3 706.3,351.5 C706.3,383.6 706.3,415.7 706.3,447.9 C706.3,482.9 706.3,517.9 706.3,553 C706.3,588.4 706.3,623.7 706.3,659.1 C706.3,692.1 706.3,725 706.3,758 C706.3,786 706.3,814 706.3,842 C706.3,862 706.3,882.1 706.3,902.1 C706.3,911.6 706.2,921.2 706.3,930.7 C706.3,931.1 706.3,931.5 706.3,931.9 C706.3,952.8 724.7,972.9 746.3,971.9 C768,970.9 786.3,954.3 786.3,931.9 L786.3,931.9 Z" id="Path"></path></g></g>',
			'viewbox' => '0 0 984 972',
		];

		$icons['bag'] = [
			'title' => 'Shopping Bag',
			'icon' => '<path d="M21,3h-4.4C15.8,1.2,14,0,12,0S8.2,1.2,7.4,3H3C2.4,3,2,3.4,2,4v19c0,0.6,0.4,1,1,1h18c0.6,0,1-0.4,1-1V4  C22,3.4,21.6,3,21,3z M12,1c1.5,0,2.8,0.8,3.4,2H8.6C9.2,1.8,10.5,1,12,1z M20,22H4v-4h16V22z M20,17H4V5h3v4h1V5h8v4h1V5h3V17z"/>',
			'viewbox' => '0 0 24 24',
		];

		$icons['bag2'] = [
			'title' => 'Shopping Bag',
			'icon' => '<g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
            <path d="M16,7 L16,6 C16,2.7 13.3,0 10,0 C6.7,0 4,2.7 4,6 L4,7 L0,7 L0,17 C0,18.7 1.3,20 3,20 L17,20 C18.7,20 20,18.7 20,17 L20,7 L16,7 Z M6,6 C6,3.8 7.8,2 10,2 C12.2,2 14,3.8 14,6 L14,7 L6,7 L6,6 Z M18,17 C18,17.6 17.6,18 17,18 L3,18 C2.4,18 2,17.6 2,17 L2,9 L4,9 L4,11 L6,11 L6,9 L14,9 L14,11 L16,11 L16,9 L18,9 L18,17 Z"  fill="currentColor" fill-rule="nonzero"></path></g>',
			'viewbox' => '0 0 20 20',
		];

		$icons['bag3'] = [
			'title' => 'Shopping Bag',
			'icon' => '<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
            <path d="M321.8711,300.957 L303.522,36.4277 C302.041719,15.9414544 285.020071,0.0593928722 264.4805,0 L57.52,0 C36.9804294,0.0593928722 19.9587808,15.9414544 18.4785,36.4277 L0.1289,300.957 C-1.21755381,320.368553 5.55493542,339.467941 18.8293837,353.69504 C32.1038319,367.922139 50.688806,376.00001 70.147,376 L251.853,376 C271.311194,376.00001 289.896168,367.922139 303.170616,353.69504 C316.445065,339.467941 323.217554,320.368553 321.8711,300.957 L321.8711,300.957 Z M281.2358,333.2285 C273.62573,341.360992 262.990788,345.983566 251.853,346 L70.147,346 C59.0060532,345.999675 48.3651702,341.374499 40.7647499,333.228684 C33.1643297,325.082868 29.2864812,314.14747 30.057,303.0332 L48.4062,38.5039 C48.7517988,33.7215957 52.725245,30.0140545 57.52,30 L264.481,30 C269.275716,30.0141067 273.249104,33.7216339 273.5947,38.5039 L291.9439,303.0332 C292.698034,314.145234 288.822287,325.074284 281.2358,333.2285 Z M231,70 L231,98 C231,139.3086 203.5234,166 161,166 C118.4766,166 91,139.3086 91,98 L91,70 C91,61.7157288 97.7157288,55 106,55 C114.284271,55 121,61.7157288 121,70 L121,98 C121,129.4072 142.7524,136 161,136 C179.2476,136 201,129.4072 201,98 L201,70 C201,61.7157288 207.715729,55 216,55 C224.284271,55 231,61.7157288 231,70 Z" fill="currentColor" fill-rule="nonzero"></path></g>',
			'viewbox' => '0 0 322 376',
		];

		$icons['basket'] = [
			'title' => 'Shopping Basket',
			'icon' => ' <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
            <path d="M90,31.6 L90,38.5 L85.9,38.5 L77.4,81.7 L72.6,81.7 L13.8,81.7 L12.8,81.7 L4.3,38.5 L-5.68434189e-14,38.5 L-5.68434189e-14,31.6 L90,31.6 Z M71.7,74.8 L78.9,38.5 L11.3,38.5 L18.4,74.8 L71.7,74.8 Z M45,67.2 C43.1,67.2 41.6,65.6 41.6,63.7 L41.6,49.8 C41.6,47.9 43.1,46.4 45,46.4 C46.9,46.4 48.4,47.9 48.4,49.8 L48.4,63.8 C48.4,65.7 46.9,67.2 45,67.2 Z M26.3,64.5 L23.3,50.5 C22.8,48.4 24.4,46.4 26.6,46.4 C28.2,46.4 29.6,47.5 29.9,49.1 L32.9,63.1 C33.4,65.2 31.8,67.2 29.6,67.2 C28,67.2 26.6,66.1 26.3,64.5 Z M60.9,67.2 C58.7,67.2 57.1,65.1 57.6,63.1 L60.6,49.1 C60.9,47.5 62.3,46.4 63.9,46.4 C66,46.4 67.7,48.4 67.2,50.5 L64.2,64.5 C63.9,66.1 62.5,67.2 60.9,67.2 Z M45.9,9.1 L34.6,29.6 L27.3,29.6 C27.4,29.4 27.4,29.3 27.5,29.1 L41.9,2.5 C42.5,0.8 44.3,-0.1 46,0.4 C47.6,5.32907052e-14 49.4,0.8 50.1,2.5 L64.2,29.1 C64.3,29.3 64.4,29.4 64.4,29.6 L57.1,29.6 L45.9,9.1 Z" fill="currentColor" fill-rule="nonzero"></path></g>',
			'viewbox' => '0 0 90 82',
		];

		$icons['basket2'] = [
			'title' => 'Shopping Basket',
			'icon' => '<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
            <path d="M8.374,33.3777756 C7.874,33.9677756 7.564,34.7777756 7.564,35.6777756 C7.564,37.4677756 8.804,38.9277756 10.334,38.9277756 L82.844,38.9277756 C84.374,38.9277756 85.614,37.4677756 85.614,35.6777756 C85.614,34.4377756 85.024,33.3677756 84.164,32.8177756 C83.774,32.5677756 83.324,32.4277756 82.844,32.4277756 L10.334,32.4277756 C9.854,32.4277756 9.404,32.5677756 9.014,32.8177756 C8.773,32.9677756 8.563,33.1577756 8.374,33.3777756 Z M86.914,24.5277756 C86.914,24.5277756 92.833,27.9937756 92.833,32.0437756 L85.284,65.9777756 C85.284,71.1577756 81.094,75.3477756 75.914,75.3477756 L17.254,75.3477756 C12.084,75.3477756 7.894,71.1577756 7.894,65.9777756 L-1.13686838e-13,32.2107756 C-1.13686838e-13,28.5507756 5.244,24.9677756 5.244,24.9677756 L37.964,0.157775643 C38.684,-0.382224357 40.284,0.507775643 41.534,2.15777564 C42.784,3.79777564 43.204,5.57777564 42.484,6.12777564 L18.964,23.9677756 L73.794,23.9677756 L50.374,6.21777564 C49.654,5.66777564 50.084,3.88777564 51.334,2.23777564 C52.584,0.587775643 54.174,-0.302224357 54.904,0.247775643 L86.914,24.5277756 Z M83.173,48.6877756 C83.173,46.8877756 82.013,45.4277756 80.583,45.4277756 L12.593,45.4277756 C11.873,45.4277756 11.233,45.7977756 10.763,46.3777756 C10.293,46.9777756 10.003,47.7877756 10.003,48.6877756 C10.003,50.4777756 11.163,51.9377756 12.593,51.9377756 L80.583,51.9377756 C82.014,51.9377756 83.173,50.4777756 83.173,48.6877756 Z M80.563,61.6877756 C80.563,59.8977756 79.493,58.4377756 78.163,58.4377756 L15.013,58.4377756 C14.353,58.4377756 13.743,58.7977756 13.313,59.3877756 C12.873,59.9777756 12.603,60.7977756 12.603,61.6877756 C12.603,63.4877756 13.683,64.9377756 15.013,64.9377756 L78.163,64.9377756 C79.494,64.9377756 80.563,63.4877756 80.563,61.6877756 Z"  fill="currentColor" fill-rule="nonzero"></path></g>',
			'viewbox' => '0 0 93 76',
		];

		$icons['cart'] = [
			'title' => 'Shopping Cart',
			'icon' => '<g  stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
            <path d="M100,12.523 L24.5,12.523 L23.521,9.105 C20.574,-1.391 6.253,-3.204 0.8,6.338 C-1.482,10.334 4.513,13.759 6.796,9.763 C9.204,5.55 15.587,6.353 16.881,10.992 L31.69,62.739 C30.081,60.341 27.347,58.762 24.244,58.762 C19.295,58.762 15.283,62.774 15.283,67.719 C15.283,72.668 19.295,76.682 24.244,76.682 C29.193,76.682 33.202,72.668 33.202,67.719 C33.202,67.028 33.116,66.362 32.969,65.717 L46.828,65.717 L67.339,65.717 C67.184,66.375 67.093,67.061 67.093,67.772 C67.093,72.721 71.103,76.733 76.052,76.733 C81,76.733 85.012,72.721 85.012,67.772 C85.012,62.877 81.085,58.909 76.207,58.821 C76.168,58.821 76.131,58.809 76.085,58.809 L46.828,58.809 L37.745,58.809 L35.794,51.989 L96.453,42.583 L100,12.523 Z M90.212,36.565 L33.879,45.295 L26.476,19.425 L92.234,19.425 L90.212,36.565 Z"  fill="currentColor" fill-rule="nonzero"></path></g>',
			'viewbox' => '0 0 100 77',
		];

		$icons['cart2'] = [
			'title' => 'Shopping Cart',
			'icon' => '<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
            <g fill="currentColor" fill-rule="nonzero">
                <path d="M16.821596,22.0969625 C17.8972968,22.0969625 18.7703293,22.9705709 18.7703293,24.0469812 C18.7703293,25.1246916 17.8972968,25.997 16.821596,25.997 C15.744596,25.997 14.8728626,25.1246916 14.8728626,24.0469812 C14.8728626,22.9705709 15.744596,22.0969625 16.821596,22.0969625 Z M5.19701194,22.0969625 C6.27401189,22.0969625 7.14574527,22.9705709 7.14574527,24.0469812 C7.14574527,25.1246916 6.27401189,25.997 5.19701194,25.997 C4.12131115,25.997 3.24827862,25.1246916 3.24827862,24.0469812 C3.24827862,22.9705709 4.12131115,22.0969625 5.19701194,22.0969625 Z M24.6228951,2.30926389e-14 L26,2.30926389e-14 C25.9870084,0.07800075 25.9870084,0.1560015 25.9870084,0.23400225 L25.9870084,2.600025 L24.6358867,2.600025 C23.9213511,2.600025 23.2587818,2.88602775 22.7910858,3.36703238 C22.6741618,3.4840335 22.5702294,3.60103463 22.4662969,3.744036 C22.1934742,4.16004 22.024584,4.66704488 22.024584,5.21305013 L22.024584,9.85409475 L22.0180882,9.85409475 L22.0180882,14.2936374 C22.0180882,17.1679651 19.6900015,19.4975875 16.8175686,19.4975875 L5.20051966,19.4975875 C2.3293859,19.4975875 -3.90798505e-14,17.1679651 -3.90798505e-14,14.2936374 L-3.90798505e-14,7.2592698 L2.5983111,7.2592698 L2.5983111,14.2936374 C2.5983111,15.7288512 3.76625194,16.8975625 5.20051966,16.8975625 L16.8175686,16.8975625 C18.2518363,16.8975625 19.4197771,15.7288512 19.4197771,14.2936374 L19.4197771,9.8592948 L7.79493329,9.8592948 L7.79493329,7.2592698 L19.4262729,7.2592698 L19.4262729,5.20005 C19.4262729,2.32702238 21.7517614,2.30926389e-14 24.6228951,2.30926389e-14 Z"></path></g></g>',
			'viewbox' => '0 0 26 26',
		];

		$icons['cart3'] = [
			'title' => 'Shopping Cart',
			'icon' => '<path d="M42.8,17.6H30c-1.7,0-3-1.3-3-3s1.3-3,3-3h12.8c1.7,0,3,1.3,3,3S44.5,17.6,42.8,17.6z"></path>
			<circle cx="23.7" cy="36.1" r="4"></circle>
			<circle cx="49.1" cy="36.1" r="4"></circle>
			<path d="M57,5.1c-1.6-0.4-3.2,0.5-3.7,2.1l-4.1,15.3H23.6L18.2,2.2C17.8,0.9,16.7,0,15.3,0H3.1c-1.7,0-3,1.3-3,3s1.3,3,3,3h7.6c1.4,0,2.5,0.9,2.9,2.2l0,0l4.8,18.1c0.4,1.3,1.5,2.2,2.9,2.2h30.2c1.4,0,2.5-0.9,2.9-2.2l4.7-17.5C59.5,7.1,58.6,5.5,57,5.1z"></path>',
			'viewbox' => '0 0 59 40',
		];

		$icons['play'] = [
			'title' => 'Play',
			'icon' => '<path d="M371.045169,237.000453 L170.343473,91.5953122 C162.994361,86.2740793 153.274907,85.5144155 145.184876,89.6289388 C137.094845,93.7434622 132.001167,102.036963 132,111.096487 L132,401.912824 C132.002394,410.971622 137.097643,419.263499 145.188322,423.375156 C153.279,427.486816 162.997579,426.723282 170.343473,421.398862 L371.045169,275.987667 C377.299256,271.453773 381,264.206956 381,256.49406 C381,248.781164 377.299256,241.534347 371.045169,237.000453 L371.045169,237.000453 Z" fill="var(--icon-fill, currentColor)" stroke="var(--stroke-color, none)" stroke-width="var(--stroke-width, 2px)" fill-rule="nonzero"></path>',
			'viewbox' => '0 0 512 512',
		];

		$icons['minus'] = [
			'icon' => '<rect width="10" height="2" x="7" y="11" fill="currentColor" ></rect>',
			'viewbox' => '0 0 24 24',
		];

		$icons['plus'] = [
			'icon' => '<polygon points="11 11 11 6 13 6 13 11 18 11 18 13 13 13 13 18 11 18 11 13 6 13 6 11" fill="currentColor" ></polygon>',
			'viewbox' => '0 0 24 24',
		];

		$icons['plus-stroke'] = [
			'icon' => '<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd" stroke-linecap="square">
            <path d="M6,1 L6,11" stroke="currentColor" stroke-width="var(--stroke-width, 2px)"></path>
            <path d="M1,6 L11,6" stroke="currentColor" stroke-width="var(--stroke-width, 2px)"></path></g>',
			'viewbox' => '0 0 12 12',
		];

		$icons['zoom'] = [
			'icon' => '<path d="M15.853 16.56c-1.683 1.517-3.911 2.44-6.353 2.44-5.243 0-9.5-4.257-9.5-9.5s4.257-9.5 9.5-9.5 9.5 4.257 9.5 9.5c0 2.442-.923 4.67-2.44 6.353l7.44 7.44-.707.707-7.44-7.44zm-6.353-15.56c4.691 0 8.5 3.809 8.5 8.5s-3.809 8.5-8.5 8.5-8.5-3.809-8.5-8.5 3.809-8.5 8.5-8.5zm-4.5 8h4v-4h1v4h4v1h-4v4h-1v-4h-4v-1z"/>',
			'viewbox' => '0 0 24 24',
		];

		$icons['dots'] = [
			'icon' => '<path d="M46,20.182 C40.5743546,20.182 36.176,15.7836454 36.176,10.358 C36.176,4.93235462 40.5743546,0.534 46,0.534 C51.4256454,0.534 55.824,4.93235462 55.824,10.358 C55.824,15.7836454 51.4256454,20.182 46,20.182 Z M81.25,20.182 C75.8243546,20.182 71.426,15.7836454 71.426,10.358 C71.426,4.93235462 75.8243546,0.534 81.25,0.534 C86.6756454,0.534 91.074,4.93235462 91.074,10.358 C91.074,15.7836454 86.6756454,20.182 81.25,20.182 Z M10.75,20.182 C5.32435462,20.182 0.926,15.7836454 0.926,10.358 C0.926,4.93235462 5.32435462,0.534 10.75,0.534 C16.1756454,0.534 20.574,4.93235462 20.574,10.358 C20.574,15.7836454 16.1756454,20.182 10.75,20.182 Z" fill="currentColor" fill-rule="nonzero"></path>',
			'viewbox' => '0 0 92 21',
		];

		$icons['bolt'] = [
			'icon' => '<path d="M2.35708787,0.000354590159 C2.27188673,0.00914529356 2.19621068,0.0586331432 2.15399926,0.133163039 L0.0368159938,3.83629609 C-0.0102857846,3.91833632 -0.0100074405,4.01928104 0.0375460522,4.10106027 C0.0850995448,4.18283949 0.172693454,4.23301142 0.267292866,4.23265435 L1.45275025,4.23265435 L0.0228633506,7.56836805 C-0.029303275,7.68565641 0.010235551,7.82346928 0.116649538,7.8952605 C0.223063526,7.96705173 0.36565562,7.95211181 0.454878319,7.85982299 L5.21634466,3.09577286 C5.29166863,3.01997959 5.3140132,2.90632023 5.27298679,2.80765335 C5.23196037,2.70898648 5.13561584,2.64467892 5.02875932,2.64463764 L3.90996447,2.64463764 L5.25561888,0.400846942 C5.30452796,0.319121386 5.30574321,0.217416701 5.25880087,0.134545835 C5.21185852,0.0516749679 5.12400195,0.000425168983 5.02875932,0.000354590159 L2.38447621,0.000354590159 C2.37535288,-0.00011819672 2.36621119,-0.00011819672 2.35708787,0.000354590159 Z M2.53692172,0.527454219 L4.56212111,0.527454219 L3.21439977,2.77382866 C3.16553766,2.85547498 3.16427388,2.95706906 3.21108988,3.03990558 C3.25790589,3.12274211 3.3455924,3.17406491 3.44074261,3.17432103 L4.39003849,3.17432103 L1.05019081,6.51416884 L2.09715538,4.07245735 C2.13215422,3.99091215 2.12394809,3.89725269 2.07530194,3.82303618 C2.02665579,3.74881968 1.94404705,3.70392835 1.85530955,3.70348769 L0.722045464,3.70348769 L2.53692172,0.527454219 Z" id="path7641" fill="#000000" fill="currentColor" fill-rule="nonzero"></path>',
			'viewbox' => '0 0 6 8',
		];

		$icons['bubble'] = [
			'icon' => '<path d="M161.96657,184.926705 C155.533465,190.727359 145.27,186.162126 145.27,177.5 L145.27,151.27 C145.27,149.169485 144.435574,147.155002 142.950286,145.669714 C141.464998,144.184426 139.450515,143.35 137.35,143.35 L28.74,143.35 C21.3378078,143.35 14.2387901,140.409491 9.00464974,135.17535 C3.77050941,129.94121 0.83,122.842192 0.83,115.44 L0.830001559,28.4455835 C0.825867057,21.0406916 3.76455115,13.9376698 8.99913966,8.70015856 C14.2337282,3.46264733 21.3351085,0.519998846 28.74,0.52 L223.259998,0.52 C230.664891,0.519998846 237.766272,3.46264733 243.00086,8.70015856 C248.235449,13.9376698 251.174133,21.0406916 251.17,28.44 L251.17,115.44 C251.17,122.842192 248.229491,129.94121 242.99535,135.17535 C237.76121,140.409491 230.662192,143.35 223.26,143.35 L211.115496,143.349998 C209.155912,143.351075 207.266303,144.078575 205.80657,145.396705 L161.96657,184.926705 Z M192.408075,130.548127 C197.535126,125.918418 204.196477,123.353798 211.11,123.35 L223.26,123.35 C225.357862,123.35 227.369802,122.516627 228.853215,121.033215 C230.336627,119.549802 231.17,117.537862 231.17,115.44 L231.170002,28.4344165 C231.171173,26.335789 230.338318,24.3227147 228.854778,22.8383466 C227.371238,21.3539785 225.358629,20.5199997 223.26,20.52 L28.7399984,20.52 C26.6413706,20.5199997 24.6287615,21.3539785 23.1452217,22.8383466 C21.661682,24.3227147 20.8288267,26.335789 20.83,28.44 L20.83,115.44 C20.83,117.537862 21.6633726,119.549802 23.1467854,121.033215 C24.6301981,122.516627 26.6421376,123.35 28.74,123.35 L137.35,123.35 C144.754844,123.35 151.856406,126.291563 157.092421,131.527579 C162.328437,136.763594 165.27,143.865156 165.27,151.27 L165.27,155.0182 L192.408075,130.548127 Z M75.13,85.04 C66.6469062,85.04 59.77,78.1630938 59.77,69.68 C59.77,61.1969062 66.6469062,54.32 75.13,54.32 C83.6130938,54.32 90.49,61.1969062 90.49,69.68 C90.49,78.1630938 83.6130938,85.04 75.13,85.04 Z M126,85.04 C117.516906,85.04 110.64,78.1630938 110.64,69.68 C110.64,61.1969062 117.516906,54.32 126,54.32 C134.483094,54.32 141.36,61.1969062 141.36,69.68 C141.36,78.1630938 134.483094,85.04 126,85.04 Z M176.87,85.04 C168.386906,85.04 161.51,78.1630938 161.51,69.68 C161.51,61.1969062 168.386906,54.32 176.87,54.32 C185.353094,54.32 192.23,61.1969062 192.23,69.68 C192.23,78.1630938 185.353094,85.04 176.87,85.04 Z" fill="currentColor" fill-rule="nonzero"></path>',
			'viewbox' => '0 0 252 188',
		];

		$icons['360'] = [
			'icon' => '<path d="m322.285156 335.644531c-7.441406 0-13.898437-5.53125-14.863281-13.105469-1.042969-8.21875 4.769531-15.726562 12.984375-16.773437 47.398438-6.039063 89.84375-18.882813 119.515625-36.171875 27.136719-15.808594 42.078125-34.394531 42.078125-52.332031 0-19.769531-17.484375-35.945313-32.15625-46.039063-6.824219-4.695312-8.550781-14.03125-3.855469-20.859375 4.695313-6.824219 14.035157-8.550781 20.859375-3.855469 29.539063 20.320313 45.152344 44.785157 45.152344 70.757813 0 29.476563-19.699219 56.535156-56.972656 78.25-33.550782 19.546875-78.789063 33.382813-130.828125 40.011719-.644531.078125-1.285157.117187-1.914063.117187zm0 0"/><path d="m252.34375 314.15625-40-40c-5.859375-5.859375-15.355469-5.859375-21.214844 0-5.855468 5.855469-5.855468 15.355469 0 21.210938l11.6875 11.6875c-44.8125-4.628907-85.523437-15.0625-117.046875-30.222657-35.441406-17.042969-55.769531-38.757812-55.769531-59.570312 0-17.652344 14.554688-36 40.980469-51.664063 7.128906-4.222656 9.480469-13.425781 5.257812-20.550781-4.226562-7.128906-13.429687-9.480469-20.554687-5.257813-46.023438 27.28125-55.683594 57.1875-55.683594 77.472657 0 33.28125 25.84375 64.039062 72.769531 86.609375 36.421875 17.511718 83.535157 29.242187 134.863281 33.78125l-16.503906 16.503906c-5.855468 5.855469-5.855468 15.355469 0 21.214844 2.929688 2.925781 6.769532 4.390625 10.609375 4.390625 3.835938 0 7.675781-1.464844 10.605469-4.390625l40-40c5.855469-5.859375 5.855469-15.359375 0-21.214844zm0 0"/><path d="m157.097656 187.222656v-3.609375c0-12.730469-7.792968-15.199219-18.242187-15.199219-6.460938 0-8.550781-5.699218-8.550781-11.398437 0-5.703125 2.089843-11.402344 8.550781-11.402344 7.21875 0 14.820312-.949219 14.820312-16.339843 0-11.019532-6.269531-13.679688-14.0625-13.679688-9.308593 0-14.058593 2.28125-14.058593 9.691406 0 6.457032-2.851563 10.828125-13.871094 10.828125-13.679688 0-15.386719-2.851562-15.386719-11.972656 0-14.816406 10.636719-34.007813 43.316406-34.007813 24.132813 0 42.371094 8.738282 42.371094 34.390626 0 13.867187-5.128906 26.789062-14.628906 31.160156 11.210937 4.179687 19.378906 12.539062 19.378906 27.929687v3.609375c0 31.160156-21.46875 42.941406-48.070313 42.941406-32.679687 0-45.21875-19.949218-45.21875-35.910156 0-8.550781 3.609376-10.832031 14.058594-10.832031 12.160156 0 15.199219 2.660156 15.199219 9.882813 0 8.929687 8.363281 11.019531 16.910156 11.019531 12.921875 0 17.484375-4.75 17.484375-17.101563zm0 0"/><path d="m302.066406 183.613281v1.710938c0 32.679687-20.332031 44.839843-46.550781 44.839843s-46.742187-12.160156-46.742187-44.839843v-50.351563c0-32.679687 21.089843-44.839844 48.453124-44.839844 32.109376 0 44.839844 19.949219 44.839844 35.71875 0 9.121094-4.371094 11.96875-13.871094 11.96875-8.167968 0-15.390624-2.089843-15.390624-10.828124 0-7.21875-7.597657-11.019532-16.527344-11.019532-11.210938 0-17.863282 5.890625-17.863282 19v17.097656c6.082032-6.648437 14.632813-8.359374 23.753907-8.359374 21.65625 0 39.898437 9.5 39.898437 39.902343zm-63.652344 3.800781c0 13.109376 6.460938 18.808594 17.101563 18.808594s16.910156-5.699218 16.910156-18.808594v-1.710937c0-13.871094-6.269531-19.191406-17.101562-19.191406-10.257813 0-16.910157 4.941406-16.910157 17.480469zm0 0"/><path d="m325.054688 185.324219v-50.351563c0-32.679687 20.328124-44.839844 46.550781-44.839844 26.21875 0 46.738281 12.160157 46.738281 44.839844v50.351563c0 32.679687-20.519531 44.839843-46.738281 44.839843-26.222657 0-46.550781-12.160156-46.550781-44.839843zm63.648437-50.351563c0-13.109375-6.457031-19-17.097656-19s-16.910157 5.890625-16.910157 19v50.351563c0 13.109375 6.269532 19 16.910157 19s17.097656-5.890625 17.097656-19zm0 0"/><path d="m454.351562 90c-24.816406 0-45-20.1875-45-45s20.183594-45 45-45c24.8125 0 45 20.1875 45 45s-20.1875 45-45 45zm0-60c-8.273437 0-15 6.730469-15 15 0 8.273438 6.726563 15 15 15 8.269532 0 15-6.726562 15-15 0-8.269531-6.730468-15-15-15zm0 0"/>',
			'viewbox' => '0 -66 512.001 512',
		];

		$icons['star'] = [
			'icon' => '<polygon stroke="currentColor" stroke-width="var(--stroke-width, 0px)" fill="var(--icon-fill, currentColor)" points="25.0000141 1 32.1197421 17.2299594 49 19.3344382 36.5200356 31.4694851 39.8327976 49 25.0000141 40.2699874 10.1671802 49 13.4799927 31.4694851 1 19.3344382 17.8802862 17.2299594"></polygon>',
			'viewbox' => '0 0 50 50',
		];

		$icons['arrow-classic'] = [
			'icon' => '<polygon fill="var(--icon-fill, currentColor)" points="8 0 6.6 1.4 12.2 7 0 7 0 9 12.2 9 6.6 14.6 8 16 16 8"></polygon>',
			'viewbox' => '0 0 16 16',
		];

		return $icons;


	}
endif;

if(!function_exists('reycore__social_icons_raw')):
	/**
	 * Social icons raw
	 *
	 * @since 2.4.0
	 **/
	function reycore__social_icons_raw()
	{

		$icons['rss'] = [
			'title' => 'RSS',
			'icon' => '<path fill="currentColor" d="M128.081 415.959c0 35.369-28.672 64.041-64.041 64.041S0 451.328 0 415.959s28.672-64.041 64.041-64.041 64.04 28.673 64.04 64.041zm175.66 47.25c-8.354-154.6-132.185-278.587-286.95-286.95C7.656 175.765 0 183.105 0 192.253v48.069c0 8.415 6.49 15.472 14.887 16.018 111.832 7.284 201.473 96.702 208.772 208.772.547 8.397 7.604 14.887 16.018 14.887h48.069c9.149.001 16.489-7.655 15.995-16.79zm144.249.288C439.596 229.677 251.465 40.445 16.503 32.01 7.473 31.686 0 38.981 0 48.016v48.068c0 8.625 6.835 15.645 15.453 15.999 191.179 7.839 344.627 161.316 352.465 352.465.353 8.618 7.373 15.453 15.999 15.453h48.068c9.034-.001 16.329-7.474 16.005-16.504z"></path>',
			'viewbox' => '0 0 448 512',
		];

		$icons['shopping-cart'] = [
			'title'   => 'Cart',
			'icon'    => '<path d = "M21,3h-4.4C15.8,1.2,14,0,12,0S8.2,1.2,7.4,3H3C2.4,3,2,3.4,2,4v19c0,0.6,0.4,1,1,1h18c0.6,0,1-0.4,1-1V4  C22,3.4,21.6,3,21,3z M12,1c1.5,0,2.8,0.8,3.4,2H8.6C9.2,1.8,10.5,1,12,1z M20,22H4v-4h16V22z M20,17H4V5h3v4h1V5h8v4h1V5h3V17z"/>',
			'viewbox' => '0 0 24 24',
		];

		$icons['envelope'] = [
			'title'   => 'Mail',
			'icon'    => '<path d="M28,5H4C1.791,5,0,6.792,0,9v13c0,2.209,1.791,4,4,4h24c2.209,0,4-1.791,4-4V9  C32,6.792,30.209,5,28,5z M2,10.25l6.999,5.25L2,20.75V10.25z M30,22c0,1.104-0.898,2-2,2H4c-1.103,0-2-0.896-2-2l7.832-5.875  l4.368,3.277c0.533,0.398,1.166,0.6,1.8,0.6c0.633,0,1.266-0.201,1.799-0.6l4.369-3.277L30,22L30,22z M30,20.75l-7-5.25l7-5.25  V20.75z M17.199,18.602c-0.349,0.262-0.763,0.4-1.199,0.4c-0.436,0-0.851-0.139-1.2-0.4L10.665,15.5l-0.833-0.625L2,9.001V9  c0-1.103,0.897-2,2-2h24c1.102,0,2,0.897,2,2L17.199,18.602z"></path>',
			'viewbox' => '0 0 32 32',
		];

		$icons['500px'] = [
			'title'   => '500px',
			'icon'    => '<path d="M103.3 344.3c-6.5-14.2-6.9-18.3 7.4-23.1 25.6-8 8 9.2 43.2 49.2h.3v-93.9c1.2-50.2 44-92.2 97.7-92.2 53.9 0 97.7 43.5 97.7 96.8 0 63.4-60.8 113.2-128.5 93.3-10.5-4.2-2.1-31.7 8.5-28.6 53 0 89.4-10.1 89.4-64.4 0-61-77.1-89.6-116.9-44.6-23.5 26.4-17.6 42.1-17.6 157.6 50.7 31 118.3 22 160.4-20.1 24.8-24.8 38.5-58 38.5-93 0-35.2-13.8-68.2-38.8-93.3-24.8-24.8-57.8-38.5-93.3-38.5s-68.8 13.8-93.5 38.5c-.3.3-16 16.5-21.2 23.9l-.5.6c-3.3 4.7-6.3 9.1-20.1 6.1-6.9-1.7-14.3-5.8-14.3-11.8V20c0-5 3.9-10.5 10.5-10.5h241.3c8.3 0 8.3 11.6 8.3 15.1 0 3.9 0 15.1-8.3 15.1H130.3v132.9h.3c104.2-109.8 282.8-36 282.8 108.9 0 178.1-244.8 220.3-310.1 62.8zm63.3-260.8c-.5 4.2 4.6 24.5 14.6 20.6C306 56.6 384 144.5 390.6 144.5c4.8 0 22.8-15.3 14.3-22.8-93.2-89-234.5-57-238.3-38.2zM393 414.7C283 524.6 94 475.5 61 310.5c0-12.2-30.4-7.4-28.9 3.3 24 173.4 246 256.9 381.6 121.3 6.9-7.8-12.6-28.4-20.7-20.4zM213.6 306.6c0 4 4.3 7.3 5.5 8.5 3 3 6.1 4.4 8.5 4.4 3.8 0 2.6.2 22.3-19.5 19.6 19.3 19.1 19.5 22.3 19.5 5.4 0 18.5-10.4 10.7-18.2L265.6 284l18.2-18.2c6.3-6.8-10.1-21.8-16.2-15.7L249.7 268c-18.6-18.8-18.4-19.5-21.5-19.5-5 0-18 11.7-12.4 17.3L234 284c-18.1 17.9-20.4 19.2-20.4 22.6z"></path>',
			'viewbox' => '0 0 448 512',
		];

		$icons['youtube'] = [
			'title'   => 'YouTube',
			'icon'    => '<path d="M549.655 124.083c-6.281-23.65-24.787-42.276-48.284-48.597C458.781 64 288 64 288 64S117.22 64 74.629 75.486c-23.497 6.322-42.003 24.947-48.284 48.597-11.412 42.867-11.412 132.305-11.412 132.305s0 89.438 11.412 132.305c6.281 23.65 24.787 41.5 48.284 47.821C117.22 448 288 448 288 448s170.78 0 213.371-11.486c23.497-6.321 42.003-24.171 48.284-47.821 11.412-42.867 11.412-132.305 11.412-132.305s0-89.438-11.412-132.305zm-317.51 213.508V175.185l142.739 81.205-142.739 81.201z"></path>',
			'viewbox' => '0 0 576 512',
		];

		$icons['yelp'] = [
			'title' => 'Yelp',
			'icon' => '<path d="M42.9 240.32l99.62 48.61c19.2 9.4 16.2 37.51-4.5 42.71L30.5 358.45a22.79 22.79 0 0 1-28.21-19.6 197.16 197.16 0 0 1 9-85.32 22.8 22.8 0 0 1 31.61-13.21zm44 239.25a199.45 199.45 0 0 0 79.42 32.11A22.78 22.78 0 0 0 192.94 490l3.9-110.82c.7-21.3-25.5-31.91-39.81-16.1l-74.21 82.4a22.82 22.82 0 0 0 4.09 34.09zm145.34-109.92l58.81 94a22.93 22.93 0 0 0 34 5.5 198.36 198.36 0 0 0 52.71-67.61A23 23 0 0 0 364.17 370l-105.42-34.26c-20.31-6.5-37.81 15.8-26.51 33.91zm148.33-132.23a197.44 197.44 0 0 0-50.41-69.31 22.85 22.85 0 0 0-34 4.4l-62 91.92c-11.9 17.7 4.7 40.61 25.2 34.71L366 268.63a23 23 0 0 0 14.61-31.21zM62.11 30.18a22.86 22.86 0 0 0-9.9 32l104.12 180.44c11.7 20.2 42.61 11.9 42.61-11.4V22.88a22.67 22.67 0 0 0-24.5-22.8 320.37 320.37 0 0 0-112.33 30.1z"></path>',
			'viewbox' => '0 0 384 512',
		];

		$icons['xing'] = [
			'title' => 'Xing',
			'icon' => '<path d="M162.7 210c-1.8 3.3-25.2 44.4-70.1 123.5-4.9 8.3-10.8 12.5-17.7 12.5H9.8c-7.7 0-12.1-7.5-8.5-14.4l69-121.3c.2 0 .2-.1 0-.3l-43.9-75.6c-4.3-7.8.3-14.1 8.5-14.1H100c7.3 0 13.3 4.1 18 12.2l44.7 77.5zM382.6 46.1l-144 253v.3L330.2 466c3.9 7.1.2 14.1-8.5 14.1h-65.2c-7.6 0-13.6-4-18-12.2l-92.4-168.5c3.3-5.8 51.5-90.8 144.8-255.2 4.6-8.1 10.4-12.2 17.5-12.2h65.7c8 0 12.3 6.7 8.5 14.1z"></path>',
			'viewbox' => '0 0 384 512',
		];

		$icons['wordpress'] = [
			'title' => 'WordPress',
			'icon' => '<path d="M61.7 169.4l101.5 278C92.2 413 43.3 340.2 43.3 256c0-30.9 6.6-60.1 18.4-86.6zm337.9 75.9c0-26.3-9.4-44.5-17.5-58.7-10.8-17.5-20.9-32.4-20.9-49.9 0-19.6 14.8-37.8 35.7-37.8.9 0 1.8.1 2.8.2-37.9-34.7-88.3-55.9-143.7-55.9-74.3 0-139.7 38.1-177.8 95.9 5 .2 9.7.3 13.7.3 22.2 0 56.7-2.7 56.7-2.7 11.5-.7 12.8 16.2 1.4 17.5 0 0-11.5 1.3-24.3 2l77.5 230.4L249.8 247l-33.1-90.8c-11.5-.7-22.3-2-22.3-2-11.5-.7-10.1-18.2 1.3-17.5 0 0 35.1 2.7 56 2.7 22.2 0 56.7-2.7 56.7-2.7 11.5-.7 12.8 16.2 1.4 17.5 0 0-11.5 1.3-24.3 2l76.9 228.7 21.2-70.9c9-29.4 16-50.5 16-68.7zm-139.9 29.3l-63.8 185.5c19.1 5.6 39.2 8.7 60.1 8.7 24.8 0 48.5-4.3 70.6-12.1-.6-.9-1.1-1.9-1.5-2.9l-65.4-179.2zm183-120.7c.9 6.8 1.4 14 1.4 21.9 0 21.6-4 45.8-16.2 76.2l-65 187.9C426.2 403 468.7 334.5 468.7 256c0-37-9.4-71.8-26-102.1zM504 256c0 136.8-111.3 248-248 248C119.2 504 8 392.7 8 256 8 119.2 119.2 8 256 8c136.7 0 248 111.2 248 248zm-11.4 0c0-130.5-106.2-236.6-236.6-236.6C125.5 19.4 19.4 125.5 19.4 256S125.6 492.6 256 492.6c130.5 0 236.6-106.1 236.6-236.6z"></path>',
			'viewbox' => '0 0 512 512',
		];

		$icons['whatsapp'] = [
			'title' => 'WhatsApp',
			'icon' => '<path d="M380.9 97.1C339 55.1 283.2 32 223.9 32c-122.4 0-222 99.6-222 222 0 39.1 10.2 77.3 29.6 111L0 480l117.7-30.9c32.4 17.7 68.9 27 106.1 27h.1c122.3 0 224.1-99.6 224.1-222 0-59.3-25.2-115-67.1-157zm-157 341.6c-33.2 0-65.7-8.9-94-25.7l-6.7-4-69.8 18.3L72 359.2l-4.4-7c-18.5-29.4-28.2-63.3-28.2-98.2 0-101.7 82.8-184.5 184.6-184.5 49.3 0 95.6 19.2 130.4 54.1 34.8 34.9 56.2 81.2 56.1 130.5 0 101.8-84.9 184.6-186.6 184.6zm101.2-138.2c-5.5-2.8-32.8-16.2-37.9-18-5.1-1.9-8.8-2.8-12.5 2.8-3.7 5.6-14.3 18-17.6 21.8-3.2 3.7-6.5 4.2-12 1.4-32.6-16.3-54-29.1-75.5-66-5.7-9.8 5.7-9.1 16.3-30.3 1.8-3.7.9-6.9-.5-9.7-1.4-2.8-12.5-30.1-17.1-41.2-4.5-10.8-9.1-9.3-12.5-9.5-3.2-.2-6.9-.2-10.6-.2-3.7 0-9.7 1.4-14.8 6.9-5.1 5.6-19.4 19-19.4 46.3 0 27.3 19.9 53.7 22.6 57.4 2.8 3.7 39.1 59.7 94.8 83.8 35.2 15.2 49 16.5 66.6 13.9 10.7-1.6 32.8-13.4 37.4-26.4 4.6-13 4.6-24.1 3.2-26.4-1.3-2.5-5-3.9-10.5-6.6z"></path>',
			'viewbox' => '0 0 448 512',
		];

		$icons['weixin'] = [
			'title' => 'Weixin',
			'icon' => '<path d="M385.2 167.6c6.4 0 12.6.3 18.8 1.1C387.4 90.3 303.3 32 207.7 32 100.5 32 13 104.8 13 197.4c0 53.4 29.3 97.5 77.9 131.6l-19.3 58.6 68-34.1c24.4 4.8 43.8 9.7 68.2 9.7 6.2 0 12.1-.3 18.3-.8-4-12.9-6.2-26.6-6.2-40.8-.1-84.9 72.9-154 165.3-154zm-104.5-52.9c14.5 0 24.2 9.7 24.2 24.4 0 14.5-9.7 24.2-24.2 24.2-14.8 0-29.3-9.7-29.3-24.2.1-14.7 14.6-24.4 29.3-24.4zm-136.4 48.6c-14.5 0-29.3-9.7-29.3-24.2 0-14.8 14.8-24.4 29.3-24.4 14.8 0 24.4 9.7 24.4 24.4 0 14.6-9.6 24.2-24.4 24.2zM563 319.4c0-77.9-77.9-141.3-165.4-141.3-92.7 0-165.4 63.4-165.4 141.3S305 460.7 397.6 460.7c19.3 0 38.9-5.1 58.6-9.9l53.4 29.3-14.8-48.6C534 402.1 563 363.2 563 319.4zm-219.1-24.5c-9.7 0-19.3-9.7-19.3-19.6 0-9.7 9.7-19.3 19.3-19.3 14.8 0 24.4 9.7 24.4 19.3 0 10-9.7 19.6-24.4 19.6zm107.1 0c-9.7 0-19.3-9.7-19.3-19.6 0-9.7 9.7-19.3 19.3-19.3 14.5 0 24.4 9.7 24.4 19.3.1 10-9.9 19.6-24.4 19.6z"></path>',
			'viewbox' => '0 0 576 512',
		];

		$icons['weibo'] = [
			'title' => 'Weibo',
			'icon' => '<path d="M407 177.6c7.6-24-13.4-46.8-37.4-41.7-22 4.8-28.8-28.1-7.1-32.8 50.1-10.9 92.3 37.1 76.5 84.8-6.8 21.2-38.8 10.8-32-10.3zM214.8 446.7C108.5 446.7 0 395.3 0 310.4c0-44.3 28-95.4 76.3-143.7C176 67 279.5 65.8 249.9 161c-4 13.1 12.3 5.7 12.3 6 79.5-33.6 140.5-16.8 114 51.4-3.7 9.4 1.1 10.9 8.3 13.1 135.7 42.3 34.8 215.2-169.7 215.2zm143.7-146.3c-5.4-55.7-78.5-94-163.4-85.7-84.8 8.6-148.8 60.3-143.4 116s78.5 94 163.4 85.7c84.8-8.6 148.8-60.3 143.4-116zM347.9 35.1c-25.9 5.6-16.8 43.7 8.3 38.3 72.3-15.2 134.8 52.8 111.7 124-7.4 24.2 29.1 37 37.4 12 31.9-99.8-55.1-195.9-157.4-174.3zm-78.5 311c-17.1 38.8-66.8 60-109.1 46.3-40.8-13.1-58-53.4-40.3-89.7 17.7-35.4 63.1-55.4 103.4-45.1 42 10.8 63.1 50.2 46 88.5zm-86.3-30c-12.9-5.4-30 .3-38 12.9-8.3 12.9-4.3 28 8.6 34 13.1 6 30.8.3 39.1-12.9 8-13.1 3.7-28.3-9.7-34zm32.6-13.4c-5.1-1.7-11.4.6-14.3 5.4-2.9 5.1-1.4 10.6 3.7 12.9 5.1 2 11.7-.3 14.6-5.4 2.8-5.2 1.1-10.9-4-12.9z"></path>',
			'viewbox' => '0 0 512 512',
		];

		$icons['vk'] = [
			'title' => 'VK',
			'icon' => '<path d="M545 117.7c3.7-12.5 0-21.7-17.8-21.7h-58.9c-15 0-21.9 7.9-25.6 16.7 0 0-30 73.1-72.4 120.5-13.7 13.7-20 18.1-27.5 18.1-3.7 0-9.4-4.4-9.4-16.9V117.7c0-15-4.2-21.7-16.6-21.7h-92.6c-9.4 0-15 7-15 13.5 0 14.2 21.2 17.5 23.4 57.5v86.8c0 19-3.4 22.5-10.9 22.5-20 0-68.6-73.4-97.4-157.4-5.8-16.3-11.5-22.9-26.6-22.9H38.8c-16.8 0-20.2 7.9-20.2 16.7 0 15.6 20 93.1 93.1 195.5C160.4 378.1 229 416 291.4 416c37.5 0 42.1-8.4 42.1-22.9 0-66.8-3.4-73.1 15.4-73.1 8.7 0 23.7 4.4 58.7 38.1 40 40 46.6 57.9 69 57.9h58.9c16.8 0 25.3-8.4 20.4-25-11.2-34.9-86.9-106.7-90.3-111.5-8.7-11.2-6.2-16.2 0-26.2.1-.1 72-101.3 79.4-135.6z"></path>',
			'viewbox' => '0 0 576 512',
		];

		$icons['vimeo-v'] = [
			'title' => 'Vimeo',
			'icon' => '<path d="M447.8 153.6c-2 43.6-32.4 103.3-91.4 179.1-60.9 79.2-112.4 118.8-154.6 118.8-26.1 0-48.2-24.1-66.3-72.3C100.3 250 85.3 174.3 56.2 174.3c-3.4 0-15.1 7.1-35.2 21.1L0 168.2c51.6-45.3 100.9-95.7 131.8-98.5 34.9-3.4 56.3 20.5 64.4 71.5 28.7 181.5 41.4 208.9 93.6 126.7 18.7-29.6 28.8-52.1 30.2-67.6 4.8-45.9-35.8-42.8-63.3-31 22-72.1 64.1-107.1 126.2-105.1 45.8 1.2 67.5 31.1 64.9 89.4z"></path>',
			'viewbox' => '0 0 448 512',
		];

		$icons['vimeo'] = [
			'title' => 'Vimeo',
			'icon' => '<path d="M403.2 32H44.8C20.1 32 0 52.1 0 76.8v358.4C0 459.9 20.1 480 44.8 480h358.4c24.7 0 44.8-20.1 44.8-44.8V76.8c0-24.7-20.1-44.8-44.8-44.8zM377 180.8c-1.4 31.5-23.4 74.7-66 129.4-44 57.2-81.3 85.8-111.7 85.8-18.9 0-34.8-17.4-47.9-52.3-25.5-93.3-36.4-148-57.4-148-2.4 0-10.9 5.1-25.4 15.2l-15.2-19.6c37.3-32.8 72.9-69.2 95.2-71.2 25.2-2.4 40.7 14.8 46.5 51.7 20.7 131.2 29.9 151 67.6 91.6 13.5-21.4 20.8-37.7 21.8-48.9 3.5-33.2-25.9-30.9-45.8-22.4 15.9-52.1 46.3-77.4 91.2-76 33.3.9 49 22.5 47.1 64.7z"></path>',
			'viewbox' => '0 0 448 512',
		];

		$icons['viber'] = [
			'title' => 'Viber',
			'icon' => '<path d="M444 49.9C431.3 38.2 379.9.9 265.3.4c0 0-135.1-8.1-200.9 52.3C27.8 89.3 14.9 143 13.5 209.5c-1.4 66.5-3.1 191.1 117 224.9h.1l-.1 51.6s-.8 20.9 13 25.1c16.6 5.2 26.4-10.7 42.3-27.8 8.7-9.4 20.7-23.2 29.8-33.7 82.2 6.9 145.3-8.9 152.5-11.2 16.6-5.4 110.5-17.4 125.7-142 15.8-128.6-7.6-209.8-49.8-246.5zM457.9 287c-12.9 104-89 110.6-103 115.1-6 1.9-61.5 15.7-131.2 11.2 0 0-52 62.7-68.2 79-5.3 5.3-11.1 4.8-11-5.7 0-6.9.4-85.7.4-85.7-.1 0-.1 0 0 0-101.8-28.2-95.8-134.3-94.7-189.8 1.1-55.5 11.6-101 42.6-131.6 55.7-50.5 170.4-43 170.4-43 96.9.4 143.3 29.6 154.1 39.4 35.7 30.6 53.9 103.8 40.6 211.1zm-139-80.8c.4 8.6-12.5 9.2-12.9.6-1.1-22-11.4-32.7-32.6-33.9-8.6-.5-7.8-13.4.7-12.9 27.9 1.5 43.4 17.5 44.8 46.2zm20.3 11.3c1-42.4-25.5-75.6-75.8-79.3-8.5-.6-7.6-13.5.9-12.9 58 4.2 88.9 44.1 87.8 92.5-.1 8.6-13.1 8.2-12.9-.3zm47 13.4c.1 8.6-12.9 8.7-12.9.1-.6-81.5-54.9-125.9-120.8-126.4-8.5-.1-8.5-12.9 0-12.9 73.7.5 133 51.4 133.7 139.2zM374.9 329v.2c-10.8 19-31 40-51.8 33.3l-.2-.3c-21.1-5.9-70.8-31.5-102.2-56.5-16.2-12.8-31-27.9-42.4-42.4-10.3-12.9-20.7-28.2-30.8-46.6-21.3-38.5-26-55.7-26-55.7-6.7-20.8 14.2-41 33.3-51.8h.2c9.2-4.8 18-3.2 23.9 3.9 0 0 12.4 14.8 17.7 22.1 5 6.8 11.7 17.7 15.2 23.8 6.1 10.9 2.3 22-3.7 26.6l-12 9.6c-6.1 4.9-5.3 14-5.3 14s17.8 67.3 84.3 84.3c0 0 9.1.8 14-5.3l9.6-12c4.6-6 15.7-9.8 26.6-3.7 14.7 8.3 33.4 21.2 45.8 32.9 7 5.7 8.6 14.4 3.8 23.6z"></path>',
			'viewbox' => '0 0 512 512',
		];

		$icons['twitter'] = [
			'title' => 'Twitter',
			'icon' => '<path d="M459.37 151.716c.325 4.548.325 9.097.325 13.645 0 138.72-105.583 298.558-298.558 298.558-59.452 0-114.68-17.219-161.137-47.106 8.447.974 16.568 1.299 25.34 1.299 49.055 0 94.213-16.568 130.274-44.832-46.132-.975-84.792-31.188-98.112-72.772 6.498.974 12.995 1.624 19.818 1.624 9.421 0 18.843-1.3 27.614-3.573-48.081-9.747-84.143-51.98-84.143-102.985v-1.299c13.969 7.797 30.214 12.67 47.431 13.319-28.264-18.843-46.781-51.005-46.781-87.391 0-19.492 5.197-37.36 14.294-52.954 51.655 63.675 129.3 105.258 216.365 109.807-1.624-7.797-2.599-15.918-2.599-24.04 0-57.828 46.782-104.934 104.934-104.934 30.213 0 57.502 12.67 76.67 33.137 23.715-4.548 46.456-13.32 66.599-25.34-7.798 24.366-24.366 44.833-46.132 57.827 21.117-2.273 41.584-8.122 60.426-16.243-14.292 20.791-32.161 39.308-52.628 54.253z"></path>',
			'viewbox' => '0 0 512 512',
		];

		$icons['twitch'] = [
			'title' => 'Twitch',
			'icon' => '<path d="M40.1 32L10 108.9v314.3h107V480h60.2l56.8-56.8h87l117-117V32H40.1zm357.8 254.1L331 353H224l-56.8 56.8V353H76.9V72.1h321v214zM331 149v116.9h-40.1V149H331zm-107 0v116.9h-40.1V149H224z"></path>',
			'viewbox' => '0 0 448 512',
		];

		$icons['tumblr'] = [
			'title' => 'Tumblr',
			'icon' => '<path d="M309.8 480.3c-13.6 14.5-50 31.7-97.4 31.7-120.8 0-147-88.8-147-140.6v-144H17.9c-5.5 0-10-4.5-10-10v-68c0-7.2 4.5-13.6 11.3-16 62-21.8 81.5-76 84.3-117.1.8-11 6.5-16.3 16.1-16.3h70.9c5.5 0 10 4.5 10 10v115.2h83c5.5 0 10 4.4 10 9.9v81.7c0 5.5-4.5 10-10 10h-83.4V360c0 34.2 23.7 53.6 68 35.8 4.8-1.9 9-3.2 12.7-2.2 3.5.9 5.8 3.4 7.4 7.9l22 64.3c1.8 5 3.3 10.6-.4 14.5z"></path>',
			'viewbox' => '0 0 320 512',
		];

		$icons['tripadvisor'] = [
			'title' => 'Trip Advisor',
			'icon' => '<path d="M166.4 280.521c0 13.236-10.73 23.966-23.966 23.966s-23.966-10.73-23.966-23.966 10.73-23.966 23.966-23.966 23.966 10.729 23.966 23.966zm264.962-23.956c-13.23 0-23.956 10.725-23.956 23.956 0 13.23 10.725 23.956 23.956 23.956 13.23 0 23.956-10.725 23.956-23.956-.001-13.231-10.726-23.956-23.956-23.956zm89.388 139.49c-62.667 49.104-153.276 38.109-202.379-24.559l-30.979 46.325-30.683-45.939c-48.277 60.39-135.622 71.891-197.885 26.055-64.058-47.158-77.759-137.316-30.601-201.374A186.762 186.762 0 0 0 0 139.416l90.286-.05a358.48 358.48 0 0 1 197.065-54.03 350.382 350.382 0 0 1 192.181 53.349l96.218.074a185.713 185.713 0 0 0-28.352 57.649c46.793 62.747 34.964 151.37-26.648 199.647zM259.366 281.761c-.007-63.557-51.535-115.075-115.092-115.068C80.717 166.7 29.2 218.228 29.206 281.785c.007 63.557 51.535 115.075 115.092 115.068 63.513-.075 114.984-51.539 115.068-115.052v-.04zm28.591-10.455c5.433-73.44 65.51-130.884 139.12-133.022a339.146 339.146 0 0 0-139.727-27.812 356.31 356.31 0 0 0-140.164 27.253c74.344 1.582 135.299 59.424 140.771 133.581zm251.706-28.767c-21.992-59.634-88.162-90.148-147.795-68.157-59.634 21.992-90.148 88.162-68.157 147.795v.032c22.038 59.607 88.198 90.091 147.827 68.113 59.615-22.004 90.113-88.162 68.125-147.783zm-326.039 37.975v.115c-.057 39.328-31.986 71.163-71.314 71.106-39.328-.057-71.163-31.986-71.106-71.314.057-39.328 31.986-71.163 71.314-71.106 39.259.116 71.042 31.94 71.106 71.199zm-24.512 0v-.084c-.051-25.784-20.994-46.645-46.778-46.594-25.784.051-46.645 20.994-46.594 46.777.051 25.784 20.994 46.645 46.777 46.594 25.726-.113 46.537-20.968 46.595-46.693zm313.423 0v.048c-.02 39.328-31.918 71.194-71.247 71.173s-71.194-31.918-71.173-71.247c.02-39.328 31.918-71.194 71.247-71.173 39.29.066 71.121 31.909 71.173 71.199zm-24.504-.008c-.009-25.784-20.918-46.679-46.702-46.67-25.784.009-46.679 20.918-46.67 46.702.009 25.784 20.918 46.678 46.702 46.67 25.765-.046 46.636-20.928 46.67-46.693v-.009z"></path>',
			'viewbox' => '0 0 576 512',
		];

		$icons['telegram'] = [
			'title' => 'Telegram',
			'icon' => '<path d="M248 8C111 8 0 119 0 256s111 248 248 248 248-111 248-248S385 8 248 8zm121.8 169.9l-40.7 191.8c-3 13.6-11.1 16.9-22.4 10.5l-62-45.7-29.9 28.8c-3.3 3.3-6.1 6.1-12.5 6.1l4.4-63.1 114.9-103.8c5-4.4-1.1-6.9-7.7-2.5l-142 89.4-61.2-19.1c-13.3-4.2-13.6-13.3 2.8-19.7l239.1-92.2c11.1-4 20.8 2.7 17.2 19.5z"></path>',
			'viewbox' => '0 0 496 512',
		];

		$icons['stumbleupon'] = [
			'title' => 'StumbleUpon',
			'icon' => '<path d="M502.9 266v69.7c0 62.1-50.3 112.4-112.4 112.4-61.8 0-112.4-49.8-112.4-111.3v-70.2l34.3 16 51.1-15.2V338c0 14.7 12 26.5 26.7 26.5S417 352.7 417 338v-72h85.9zm-224.7-58.2l34.3 16 51.1-15.2V173c0-60.5-51.1-109-112.1-109-60.8 0-112.1 48.2-112.1 108.2v162.4c0 14.9-12 26.7-26.7 26.7S86 349.5 86 334.6V266H0v69.7C0 397.7 50.3 448 112.4 448c61.6 0 112.4-49.5 112.4-110.8V176.9c0-14.7 12-26.7 26.7-26.7s26.7 12 26.7 26.7v30.9z"></path>',
			'viewbox' => '0 0 512 512',
		];

		$icons['steam'] = [
			'title' => 'Steam',
			'icon' => '<path d="M496 256c0 137-111.2 248-248.4 248-113.8 0-209.6-76.3-239-180.4l95.2 39.3c6.4 32.1 34.9 56.4 68.9 56.4 39.2 0 71.9-32.4 70.2-73.5l84.5-60.2c52.1 1.3 95.8-40.9 95.8-93.5 0-51.6-42-93.5-93.7-93.5s-93.7 42-93.7 93.5v1.2L176.6 279c-15.5-.9-30.7 3.4-43.5 12.1L0 236.1C10.2 108.4 117.1 8 247.6 8 384.8 8 496 119 496 256zM155.7 384.3l-30.5-12.6a52.79 52.79 0 0 0 27.2 25.8c26.9 11.2 57.8-1.6 69-28.4 5.4-13 5.5-27.3.1-40.3-5.4-13-15.5-23.2-28.5-28.6-12.9-5.4-26.7-5.2-38.9-.6l31.5 13c19.8 8.2 29.2 30.9 20.9 50.7-8.3 19.9-31 29.2-50.8 21zm173.8-129.9c-34.4 0-62.4-28-62.4-62.3s28-62.3 62.4-62.3 62.4 28 62.4 62.3-27.9 62.3-62.4 62.3zm.1-15.6c25.9 0 46.9-21 46.9-46.8 0-25.9-21-46.8-46.9-46.8s-46.9 21-46.9 46.8c.1 25.8 21.1 46.8 46.9 46.8z"></path>',
			'viewbox' => '0 0 496 512',
		];

		$icons['stack-overflow'] = [
			'title' => 'Stack Overflow',
			'icon' => '<path d="M290.7 311L95 269.7 86.8 309l195.7 41zm51-87L188.2 95.7l-25.5 30.8 153.5 128.3zm-31.2 39.7L129.2 179l-16.7 36.5L293.7 300zM262 32l-32 24 119.3 160.3 32-24zm20.5 328h-200v39.7h200zm39.7 80H42.7V320h-40v160h359.5V320h-40z"></path>',
			'viewbox' => '0 0 384 512',
		];

		$icons['spotify'] = [
			'title' => 'Spotify',
			'icon' => '<path d="M248 8C111.1 8 0 119.1 0 256s111.1 248 248 248 248-111.1 248-248S384.9 8 248 8zm100.7 364.9c-4.2 0-6.8-1.3-10.7-3.6-62.4-37.6-135-39.2-206.7-24.5-3.9 1-9 2.6-11.9 2.6-9.7 0-15.8-7.7-15.8-15.8 0-10.3 6.1-15.2 13.6-16.8 81.9-18.1 165.6-16.5 237 26.2 6.1 3.9 9.7 7.4 9.7 16.5s-7.1 15.4-15.2 15.4zm26.9-65.6c-5.2 0-8.7-2.3-12.3-4.2-62.5-37-155.7-51.9-238.6-29.4-4.8 1.3-7.4 2.6-11.9 2.6-10.7 0-19.4-8.7-19.4-19.4s5.2-17.8 15.5-20.7c27.8-7.8 56.2-13.6 97.8-13.6 64.9 0 127.6 16.1 177 45.5 8.1 4.8 11.3 11 11.3 19.7-.1 10.8-8.5 19.5-19.4 19.5zm31-76.2c-5.2 0-8.4-1.3-12.9-3.9-71.2-42.5-198.5-52.7-280.9-29.7-3.6 1-8.1 2.6-12.9 2.6-13.2 0-23.3-10.3-23.3-23.6 0-13.6 8.4-21.3 17.4-23.9 35.2-10.3 74.6-15.2 117.5-15.2 73 0 149.5 15.2 205.4 47.8 7.8 4.5 12.9 10.7 12.9 22.6 0 13.6-11 23.3-23.2 23.3z"></path>',
			'viewbox' => '0 0 496 512',
		];

		$icons['soundcloud'] = [
			'title' => 'SoundCloud',
			'icon' => '<path d="M111.4 256.3l5.8 65-5.8 68.3c-.3 2.5-2.2 4.4-4.4 4.4s-4.2-1.9-4.2-4.4l-5.6-68.3 5.6-65c0-2.2 1.9-4.2 4.2-4.2 2.2 0 4.1 2 4.4 4.2zm21.4-45.6c-2.8 0-4.7 2.2-5 5l-5 105.6 5 68.3c.3 2.8 2.2 5 5 5 2.5 0 4.7-2.2 4.7-5l5.8-68.3-5.8-105.6c0-2.8-2.2-5-4.7-5zm25.5-24.1c-3.1 0-5.3 2.2-5.6 5.3l-4.4 130 4.4 67.8c.3 3.1 2.5 5.3 5.6 5.3 2.8 0 5.3-2.2 5.3-5.3l5.3-67.8-5.3-130c0-3.1-2.5-5.3-5.3-5.3zM7.2 283.2c-1.4 0-2.2 1.1-2.5 2.5L0 321.3l4.7 35c.3 1.4 1.1 2.5 2.5 2.5s2.2-1.1 2.5-2.5l5.6-35-5.6-35.6c-.3-1.4-1.1-2.5-2.5-2.5zm23.6-21.9c-1.4 0-2.5 1.1-2.5 2.5l-6.4 57.5 6.4 56.1c0 1.7 1.1 2.8 2.5 2.8s2.5-1.1 2.8-2.5l7.2-56.4-7.2-57.5c-.3-1.4-1.4-2.5-2.8-2.5zm25.3-11.4c-1.7 0-3.1 1.4-3.3 3.3L47 321.3l5.8 65.8c.3 1.7 1.7 3.1 3.3 3.1 1.7 0 3.1-1.4 3.1-3.1l6.9-65.8-6.9-68.1c0-1.9-1.4-3.3-3.1-3.3zm25.3-2.2c-1.9 0-3.6 1.4-3.6 3.6l-5.8 70 5.8 67.8c0 2.2 1.7 3.6 3.6 3.6s3.6-1.4 3.9-3.6l6.4-67.8-6.4-70c-.3-2.2-2-3.6-3.9-3.6zm241.4-110.9c-1.1-.8-2.8-1.4-4.2-1.4-2.2 0-4.2.8-5.6 1.9-1.9 1.7-3.1 4.2-3.3 6.7v.8l-3.3 176.7 1.7 32.5 1.7 31.7c.3 4.7 4.2 8.6 8.9 8.6s8.6-3.9 8.6-8.6l3.9-64.2-3.9-177.5c-.4-3-2-5.8-4.5-7.2zm-26.7 15.3c-1.4-.8-2.8-1.4-4.4-1.4s-3.1.6-4.4 1.4c-2.2 1.4-3.6 3.9-3.6 6.7l-.3 1.7-2.8 160.8s0 .3 3.1 65.6v.3c0 1.7.6 3.3 1.7 4.7 1.7 1.9 3.9 3.1 6.4 3.1 2.2 0 4.2-1.1 5.6-2.5 1.7-1.4 2.5-3.3 2.5-5.6l.3-6.7 3.1-58.6-3.3-162.8c-.3-2.8-1.7-5.3-3.9-6.7zm-111.4 22.5c-3.1 0-5.8 2.8-5.8 6.1l-4.4 140.6 4.4 67.2c.3 3.3 2.8 5.8 5.8 5.8 3.3 0 5.8-2.5 6.1-5.8l5-67.2-5-140.6c-.2-3.3-2.7-6.1-6.1-6.1zm376.7 62.8c-10.8 0-21.1 2.2-30.6 6.1-6.4-70.8-65.8-126.4-138.3-126.4-17.8 0-35 3.3-50.3 9.4-6.1 2.2-7.8 4.4-7.8 9.2v249.7c0 5 3.9 8.6 8.6 9.2h218.3c43.3 0 78.6-35 78.6-78.3.1-43.6-35.2-78.9-78.5-78.9zm-296.7-60.3c-4.2 0-7.5 3.3-7.8 7.8l-3.3 136.7 3.3 65.6c.3 4.2 3.6 7.5 7.8 7.5 4.2 0 7.5-3.3 7.5-7.5l3.9-65.6-3.9-136.7c-.3-4.5-3.3-7.8-7.5-7.8zm-53.6-7.8c-3.3 0-6.4 3.1-6.4 6.7l-3.9 145.3 3.9 66.9c.3 3.6 3.1 6.4 6.4 6.4 3.6 0 6.4-2.8 6.7-6.4l4.4-66.9-4.4-145.3c-.3-3.6-3.1-6.7-6.7-6.7zm26.7 3.4c-3.9 0-6.9 3.1-6.9 6.9L227 321.3l3.9 66.4c.3 3.9 3.1 6.9 6.9 6.9s6.9-3.1 6.9-6.9l4.2-66.4-4.2-141.7c0-3.9-3-6.9-6.9-6.9z"></path>',
			'viewbox' => '0 0 640 512',
		];

		$icons['snapchat'] = [
			'title' => 'Snapchat',
			'icon' => '<path d="M248 8C111 8 0 119 0 256s111 248 248 248 248-111 248-248S385 8 248 8zm169.5 338.9c-3.5 8.1-18.1 14-44.8 18.2-1.4 1.9-2.5 9.8-4.3 15.9-1.1 3.7-3.7 5.9-8.1 5.9h-.2c-6.2 0-12.8-2.9-25.8-2.9-17.6 0-23.7 4-37.4 13.7-14.5 10.3-28.4 19.1-49.2 18.2-21 1.6-38.6-11.2-48.5-18.2-13.8-9.7-19.8-13.7-37.4-13.7-12.5 0-20.4 3.1-25.8 3.1-5.4 0-7.5-3.3-8.3-6-1.8-6.1-2.9-14.1-4.3-16-13.8-2.1-44.8-7.5-45.5-21.4-.2-3.6 2.3-6.8 5.9-7.4 46.3-7.6 67.1-55.1 68-57.1 0-.1.1-.2.2-.3 2.5-5 3-9.2 1.6-12.5-3.4-7.9-17.9-10.7-24-13.2-15.8-6.2-18-13.4-17-18.3 1.6-8.5 14.4-13.8 21.9-10.3 5.9 2.8 11.2 4.2 15.7 4.2 3.3 0 5.5-.8 6.6-1.4-1.4-23.9-4.7-58 3.8-77.1C183.1 100 230.7 96 244.7 96c.6 0 6.1-.1 6.7-.1 34.7 0 68 17.8 84.3 54.3 8.5 19.1 5.2 53.1 3.8 77.1 1.1.6 2.9 1.3 5.7 1.4 4.3-.2 9.2-1.6 14.7-4.2 4-1.9 9.6-1.6 13.6 0 6.3 2.3 10.3 6.8 10.4 11.9.1 6.5-5.7 12.1-17.2 16.6-1.4.6-3.1 1.1-4.9 1.7-6.5 2.1-16.4 5.2-19 11.5-1.4 3.3-.8 7.5 1.6 12.5.1.1.1.2.2.3.9 2 21.7 49.5 68 57.1 4 1 7.1 5.5 4.9 10.8z"></path>',
			'viewbox' => '0 0 496 512',
		];

		$icons['slideshare'] = [
			'title' => 'SlideShare',
			'icon' => '<path d="M187.7 153.7c-34 0-61.7 25.7-61.7 57.7 0 31.7 27.7 57.7 61.7 57.7s61.7-26 61.7-57.7c0-32-27.7-57.7-61.7-57.7zm143.4 0c-34 0-61.7 25.7-61.7 57.7 0 31.7 27.7 57.7 61.7 57.7 34.3 0 61.7-26 61.7-57.7.1-32-27.4-57.7-61.7-57.7zm156.6 90l-6 4.3V49.7c0-27.4-20.6-49.7-46-49.7H76.6c-25.4 0-46 22.3-46 49.7V248c-2-1.4-4.3-2.9-6.3-4.3-15.1-10.6-25.1 4-16 17.7 18.3 22.6 53.1 50.3 106.3 72C58.3 525.1 252 555.7 248.9 457.5c0-.7.3-56.6.3-96.6 5.1 1.1 9.4 2.3 13.7 3.1 0 39.7.3 92.8.3 93.5-3.1 98.3 190.6 67.7 134.3-124 53.1-21.7 88-49.4 106.3-72 9.1-13.8-.9-28.3-16.1-17.8zm-30.5 19.2c-68.9 37.4-128.3 31.1-160.6 29.7-23.7-.9-32.6 9.1-33.7 24.9-10.3-7.7-18.6-15.5-20.3-17.1-5.1-5.4-13.7-8-27.1-7.7-31.7 1.1-89.7 7.4-157.4-28V72.3c0-34.9 8.9-45.7 40.6-45.7h317.7c30.3 0 40.9 12.9 40.9 45.7v190.6z"></path>',
			'viewbox' => '0 0 512 512',
		];

		$icons['skype'] = [
			'title' => 'Skype',
			'icon' => '<path d="M424.7 299.8c2.9-14 4.7-28.9 4.7-43.8 0-113.5-91.9-205.3-205.3-205.3-14.9 0-29.7 1.7-43.8 4.7C161.3 40.7 137.7 32 112 32 50.2 32 0 82.2 0 144c0 25.7 8.7 49.3 23.3 68.2-2.9 14-4.7 28.9-4.7 43.8 0 113.5 91.9 205.3 205.3 205.3 14.9 0 29.7-1.7 43.8-4.7 19 14.6 42.6 23.3 68.2 23.3 61.8 0 112-50.2 112-112 .1-25.6-8.6-49.2-23.2-68.1zm-194.6 91.5c-65.6 0-120.5-29.2-120.5-65 0-16 9-30.6 29.5-30.6 31.2 0 34.1 44.9 88.1 44.9 25.7 0 42.3-11.4 42.3-26.3 0-18.7-16-21.6-42-28-62.5-15.4-117.8-22-117.8-87.2 0-59.2 58.6-81.1 109.1-81.1 55.1 0 110.8 21.9 110.8 55.4 0 16.9-11.4 31.8-30.3 31.8-28.3 0-29.2-33.5-75-33.5-25.7 0-42 7-42 22.5 0 19.8 20.8 21.8 69.1 33 41.4 9.3 90.7 26.8 90.7 77.6 0 59.1-57.1 86.5-112 86.5z"></path>',
			'viewbox' => '0 0 16 16',
		];

		$icons['reddit'] = [
			'title' => 'Reddit',
			'icon' => '<path d="M201.5 305.5c-13.8 0-24.9-11.1-24.9-24.6 0-13.8 11.1-24.9 24.9-24.9 13.6 0 24.6 11.1 24.6 24.9 0 13.6-11.1 24.6-24.6 24.6zM504 256c0 137-111 248-248 248S8 393 8 256 119 8 256 8s248 111 248 248zm-132.3-41.2c-9.4 0-17.7 3.9-23.8 10-22.4-15.5-52.6-25.5-86.1-26.6l17.4-78.3 55.4 12.5c0 13.6 11.1 24.6 24.6 24.6 13.8 0 24.9-11.3 24.9-24.9s-11.1-24.9-24.9-24.9c-9.7 0-18 5.8-22.1 13.8l-61.2-13.6c-3-.8-6.1 1.4-6.9 4.4l-19.1 86.4c-33.2 1.4-63.1 11.3-85.5 26.8-6.1-6.4-14.7-10.2-24.1-10.2-34.9 0-46.3 46.9-14.4 62.8-1.1 5-1.7 10.2-1.7 15.5 0 52.6 59.2 95.2 132 95.2 73.1 0 132.3-42.6 132.3-95.2 0-5.3-.6-10.8-1.9-15.8 31.3-16 19.8-62.5-14.9-62.5zM302.8 331c-18.2 18.2-76.1 17.9-93.6 0-2.2-2.2-6.1-2.2-8.3 0-2.5 2.5-2.5 6.4 0 8.6 22.8 22.8 87.3 22.8 110.2 0 2.5-2.2 2.5-6.1 0-8.6-2.2-2.2-6.1-2.2-8.3 0zm7.7-75c-13.6 0-24.6 11.1-24.6 24.9 0 13.6 11.1 24.6 24.6 24.6 13.8 0 24.9-11.1 24.9-24.6 0-13.8-11-24.9-24.9-24.9z"></path>',
			'viewbox' => '0 0 512 512',
		];

		$icons['product-hunt'] = [
			'title' => 'Product Hunt',
			'icon' => '<path d="M326.3 218.8c0 20.5-16.7 37.2-37.2 37.2h-70.3v-74.4h70.3c20.5 0 37.2 16.7 37.2 37.2zM504 256c0 137-111 248-248 248S8 393 8 256 119 8 256 8s248 111 248 248zm-128.1-37.2c0-47.9-38.9-86.8-86.8-86.8H169.2v248h49.6v-74.4h70.3c47.9 0 86.8-38.9 86.8-86.8z"></path>',
			'viewbox' => '0 0 512 512',
		];

		$icons['pinterest-p'] = [
			'title' => 'Pinterest',
			'icon' => '<path d="M204 6.5C101.4 6.5 0 74.9 0 185.6 0 256 39.6 296 63.6 296c9.9 0 15.6-27.6 15.6-35.4 0-9.3-23.7-29.1-23.7-67.8 0-80.4 61.2-137.4 140.4-137.4 68.1 0 118.5 38.7 118.5 109.8 0 53.1-21.3 152.7-90.3 152.7-24.9 0-46.2-18-46.2-43.8 0-37.8 26.4-74.4 26.4-113.4 0-66.2-93.9-54.2-93.9 25.8 0 16.8 2.1 35.4 9.6 50.7-13.8 59.4-42 147.9-42 209.1 0 18.9 2.7 37.5 4.5 56.4 3.4 3.8 1.7 3.4 6.9 1.5 50.4-69 48.6-82.5 71.4-172.8 12.3 23.4 44.1 36 69.3 36 106.2 0 153.9-103.5 153.9-196.8C384 71.3 298.2 6.5 204 6.5z"></path>',
			'viewbox' => '0 0 384 512',
		];

		$icons['pinterest'] = [
			'title' => 'Pinterest',
			'icon' => '<path d="M496 256c0 137-111 248-248 248-25.6 0-50.2-3.9-73.4-11.1 10.1-16.5 25.2-43.5 30.8-65 3-11.6 15.4-59 15.4-59 8.1 15.4 31.7 28.5 56.8 28.5 74.8 0 128.7-68.8 128.7-154.3 0-81.9-66.9-143.2-152.9-143.2-107 0-163.9 71.8-163.9 150.1 0 36.4 19.4 81.7 50.3 96.1 4.7 2.2 7.2 1.2 8.3-3.3.8-3.4 5-20.3 6.9-28.1.6-2.5.3-4.7-1.7-7.1-10.1-12.5-18.3-35.3-18.3-56.6 0-54.7 41.4-107.6 112-107.6 60.9 0 103.6 41.5 103.6 100.9 0 67.1-33.9 113.6-78 113.6-24.3 0-42.6-20.1-36.7-44.8 7-29.5 20.5-61.3 20.5-82.6 0-19-10.2-34.9-31.4-34.9-24.9 0-44.9 25.7-44.9 60.2 0 22 7.4 36.8 7.4 36.8s-24.5 103.8-29 123.2c-5 21.4-3 51.6-.9 71.2C65.4 450.9 0 361.1 0 256 0 119 111 8 248 8s248 111 248 248z"></path>',
			'viewbox' => '0 0 496 512',
		];

		$icons['odnoklassniki'] = [
			'title' => 'Odnoklassniki',
			'icon' => '<path d="M275.1 334c-27.4 17.4-65.1 24.3-90 26.9l20.9 20.6 76.3 76.3c27.9 28.6-17.5 73.3-45.7 45.7-19.1-19.4-47.1-47.4-76.3-76.6L84 503.4c-28.2 27.5-73.6-17.6-45.4-45.7 19.4-19.4 47.1-47.4 76.3-76.3l20.6-20.6c-24.6-2.6-62.9-9.1-90.6-26.9-32.6-21-46.9-33.3-34.3-59 7.4-14.6 27.7-26.9 54.6-5.7 0 0 36.3 28.9 94.9 28.9s94.9-28.9 94.9-28.9c26.9-21.1 47.1-8.9 54.6 5.7 12.4 25.7-1.9 38-34.5 59.1zM30.3 129.7C30.3 58 88.6 0 160 0s129.7 58 129.7 129.7c0 71.4-58.3 129.4-129.7 129.4s-129.7-58-129.7-129.4zm66 0c0 35.1 28.6 63.7 63.7 63.7s63.7-28.6 63.7-63.7c0-35.4-28.6-64-63.7-64s-63.7 28.6-63.7 64z"></path>',
			'viewbox' => '0 0 320 512',
		];

		$icons['mixcloud'] = [
			'title' => 'Mixcloud',
			'icon' => '<path d="M424.43 219.729C416.124 134.727 344.135 68 256.919 68c-72.266 0-136.224 46.516-159.205 114.074-54.545 8.029-96.63 54.822-96.63 111.582 0 62.298 50.668 112.966 113.243 112.966h289.614c52.329 0 94.969-42.362 94.969-94.693 0-45.131-32.118-83.063-74.48-92.2zm-20.489 144.53H114.327c-39.04 0-70.881-31.564-70.881-70.604s31.841-70.604 70.881-70.604c18.827 0 36.548 7.475 49.838 20.766 19.963 19.963 50.133-10.227 30.18-30.18-14.675-14.398-32.672-24.365-52.053-29.349 19.935-44.3 64.79-73.926 114.628-73.926 69.496 0 125.979 56.483 125.979 125.702 0 13.568-2.215 26.857-6.369 39.594-8.943 27.517 32.133 38.939 40.147 13.29 2.769-8.306 4.984-16.889 6.369-25.472 19.381 7.476 33.502 26.303 33.502 48.453 0 28.795-23.535 52.33-52.607 52.33zm235.069-52.33c0 44.024-12.737 86.386-37.102 122.657-4.153 6.092-10.798 9.414-17.72 9.414-16.317 0-27.127-18.826-17.443-32.949 19.381-29.349 29.903-63.682 29.903-99.122s-10.521-69.773-29.903-98.845c-15.655-22.831 19.361-47.24 35.163-23.534 24.366 35.993 37.102 78.356 37.102 122.379zm-70.88 0c0 31.565-9.137 62.021-26.857 88.325-4.153 6.091-10.798 9.136-17.72 9.136-17.201 0-27.022-18.979-17.443-32.948 13.013-19.104 19.658-41.255 19.658-64.513 0-22.981-6.645-45.408-19.658-64.512-15.761-22.986 19.008-47.095 35.163-23.535 17.719 26.026 26.857 56.483 26.857 88.047z"></path>',
			'viewbox' => '0 0 640 512',
		];

		$icons['meetup'] = [
			'title' => 'Meetup',
			'icon' => '<path d="M99 414.3c1.1 5.7-2.3 11.1-8 12.3-5.4 1.1-10.9-2.3-12-8-1.1-5.4 2.3-11.1 7.7-12.3 5.4-1.2 11.1 2.3 12.3 8zm143.1 71.4c-6.3 4.6-8 13.4-3.7 20 4.6 6.6 13.4 8.3 20 3.7 6.3-4.6 8-13.4 3.4-20-4.2-6.5-13.1-8.3-19.7-3.7zm-86-462.3c6.3-1.4 10.3-7.7 8.9-14-1.1-6.6-7.4-10.6-13.7-9.1-6.3 1.4-10.3 7.7-9.1 14 1.4 6.6 7.6 10.6 13.9 9.1zM34.4 226.3c-10-6.9-23.7-4.3-30.6 6-6.9 10-4.3 24 5.7 30.9 10 7.1 23.7 4.6 30.6-5.7 6.9-10.4 4.3-24.1-5.7-31.2zm272-170.9c10.6-6.3 13.7-20 7.7-30.3-6.3-10.6-19.7-14-30-7.7s-13.7 20-7.4 30.6c6 10.3 19.4 13.7 29.7 7.4zm-191.1 58c7.7-5.4 9.4-16 4.3-23.7s-15.7-9.4-23.1-4.3c-7.7 5.4-9.4 16-4.3 23.7 5.1 7.8 15.6 9.5 23.1 4.3zm372.3 156c-7.4 1.7-12.3 9.1-10.6 16.9 1.4 7.4 8.9 12.3 16.3 10.6 7.4-1.4 12.3-8.9 10.6-16.6-1.5-7.4-8.9-12.3-16.3-10.9zm39.7-56.8c-1.1-5.7-6.6-9.1-12-8-5.7 1.1-9.1 6.9-8 12.6 1.1 5.4 6.6 9.1 12.3 8 5.4-1.5 9.1-6.9 7.7-12.6zM447 138.9c-8.6 6-10.6 17.7-4.9 26.3 5.7 8.6 17.4 10.6 26 4.9 8.3-6 10.3-17.7 4.6-26.3-5.7-8.7-17.4-10.9-25.7-4.9zm-6.3 139.4c26.3 43.1 15.1 100-26.3 129.1-17.4 12.3-37.1 17.7-56.9 17.1-12 47.1-69.4 64.6-105.1 32.6-1.1.9-2.6 1.7-3.7 2.9-39.1 27.1-92.3 17.4-119.4-22.3-9.7-14.3-14.6-30.6-15.1-46.9-65.4-10.9-90-94-41.1-139.7-28.3-46.9.6-107.4 53.4-114.9C151.6 70 234.1 38.6 290.1 82c67.4-22.3 136.3 29.4 130.9 101.1 41.1 12.6 52.8 66.9 19.7 95.2zm-70 74.3c-3.1-20.6-40.9-4.6-43.1-27.1-3.1-32 43.7-101.1 40-128-3.4-24-19.4-29.1-33.4-29.4-13.4-.3-16.9 2-21.4 4.6-2.9 1.7-6.6 4.9-11.7-.3-6.3-6-11.1-11.7-19.4-12.9-12.3-2-17.7 2-26.6 9.7-3.4 2.9-12 12.9-20 9.1-3.4-1.7-15.4-7.7-24-11.4-16.3-7.1-40 4.6-48.6 20-12.9 22.9-38 113.1-41.7 125.1-8.6 26.6 10.9 48.6 36.9 47.1 11.1-.6 18.3-4.6 25.4-17.4 4-7.4 41.7-107.7 44.6-112.6 2-3.4 8.9-8 14.6-5.1 5.7 3.1 6.9 9.4 6 15.1-1.1 9.7-28 70.9-28.9 77.7-3.4 22.9 26.9 26.6 38.6 4 3.7-7.1 45.7-92.6 49.4-98.3 4.3-6.3 7.4-8.3 11.7-8 3.1 0 8.3.9 7.1 10.9-1.4 9.4-35.1 72.3-38.9 87.7-4.6 20.6 6.6 41.4 24.9 50.6 11.4 5.7 62.5 15.7 58.5-11.1zm5.7 92.3c-10.3 7.4-12.9 22-5.7 32.6 7.1 10.6 21.4 13.1 32 6 10.6-7.4 13.1-22 6-32.6-7.4-10.6-21.7-13.5-32.3-6z"></path>',
			'viewbox' => '0 0 512 512',
		];

		$icons['medium'] = [
			'title' => 'Medium',
			'icon' => '<path d="M0 32v448h448V32H0zm372.2 106.1l-24 23c-2.1 1.6-3.1 4.2-2.7 6.7v169.3c-.4 2.6.6 5.2 2.7 6.7l23.5 23v5.1h-118V367l24.3-23.6c2.4-2.4 2.4-3.1 2.4-6.7V199.8l-67.6 171.6h-9.1L125 199.8v115c-.7 4.8 1 9.7 4.4 13.2l31.6 38.3v5.1H71.2v-5.1l31.6-38.3c3.4-3.5 4.9-8.4 4.1-13.2v-133c.4-3.7-1-7.3-3.8-9.8L75 138.1V133h87.3l67.4 148L289 133.1h83.2v5z"></path>',
			'viewbox' => '0 0 448 512',
		];

		$icons['linkedin'] = [
			'title' => 'LinkedIn',
			'icon' => '<path d="M416 32H31.9C14.3 32 0 46.5 0 64.3v383.4C0 465.5 14.3 480 31.9 480H416c17.6 0 32-14.5 32-32.3V64.3c0-17.8-14.4-32.3-32-32.3zM135.4 416H69V202.2h66.5V416zm-33.2-243c-21.3 0-38.5-17.3-38.5-38.5S80.9 96 102.2 96c21.2 0 38.5 17.3 38.5 38.5 0 21.3-17.2 38.5-38.5 38.5zm282.1 243h-66.4V312c0-24.8-.5-56.7-34.5-56.7-34.6 0-39.9 27-39.9 54.9V416h-66.4V202.2h63.7v29.2h.9c8.9-16.8 30.6-34.5 62.9-34.5 67.2 0 79.7 44.3 79.7 101.9V416z"></path>',
			'viewbox' => '0 0 448 512',
		];

		$icons['jsfiddle'] = [
			'title' => 'JSFiddle',
			'icon' => '<path d="M510.634 237.462c-4.727-2.621-5.664-5.748-6.381-10.776-2.352-16.488-3.539-33.619-9.097-49.095-35.895-99.957-153.99-143.386-246.849-91.646-27.37 15.25-48.971 36.369-65.493 63.903-3.184-1.508-5.458-2.71-7.824-3.686-30.102-12.421-59.049-10.121-85.331 9.167-25.531 18.737-36.422 44.548-32.676 76.408.355 3.025-1.967 7.621-4.514 9.545-39.712 29.992-56.031 78.065-41.902 124.615 13.831 45.569 57.514 79.796 105.608 81.433 30.291 1.031 60.637.546 90.959.539 84.041-.021 168.09.531 252.12-.48 52.664-.634 96.108-36.873 108.212-87.293 11.54-48.074-11.144-97.3-56.832-122.634zm21.107 156.88c-18.23 22.432-42.343 35.253-71.28 35.65-56.874.781-113.767.23-170.652.23 0 .7-163.028.159-163.728.154-43.861-.332-76.739-19.766-95.175-59.995-18.902-41.245-4.004-90.848 34.186-116.106 9.182-6.073 12.505-11.566 10.096-23.136-5.49-26.361 4.453-47.956 26.42-62.981 22.987-15.723 47.422-16.146 72.034-3.083 10.269 5.45 14.607 11.564 22.198-2.527 14.222-26.399 34.557-46.727 60.671-61.294 97.46-54.366 228.37 7.568 230.24 132.697.122 8.15 2.412 12.428 9.848 15.894 57.56 26.829 74.456 96.122 35.142 144.497zm-87.789-80.499c-5.848 31.157-34.622 55.096-66.666 55.095-16.953-.001-32.058-6.545-44.079-17.705-27.697-25.713-71.141-74.98-95.937-93.387-20.056-14.888-41.99-12.333-60.272 3.782-49.996 44.071 15.859 121.775 67.063 77.188 4.548-3.96 7.84-9.543 12.744-12.844 8.184-5.509 20.766-.884 13.168 10.622-17.358 26.284-49.33 38.197-78.863 29.301-28.897-8.704-48.84-35.968-48.626-70.179 1.225-22.485 12.364-43.06 35.414-55.965 22.575-12.638 46.369-13.146 66.991 2.474C295.68 280.7 320.467 323.97 352.185 343.47c24.558 15.099 54.254 7.363 68.823-17.506 28.83-49.209-34.592-105.016-78.868-63.46-3.989 3.744-6.917 8.932-11.41 11.72-10.975 6.811-17.333-4.113-12.809-10.353 20.703-28.554 50.464-40.44 83.271-28.214 31.429 11.714 49.108 44.366 42.76 78.186z"></path>',
			'viewbox' => '0 0 576 512',
		];

		$icons['instagram'] = [
			'title' => 'Instagram',
			'icon' => '<path d="M224.1 141c-63.6 0-114.9 51.3-114.9 114.9s51.3 114.9 114.9 114.9S339 319.5 339 255.9 287.7 141 224.1 141zm0 189.6c-41.1 0-74.7-33.5-74.7-74.7s33.5-74.7 74.7-74.7 74.7 33.5 74.7 74.7-33.6 74.7-74.7 74.7zm146.4-194.3c0 14.9-12 26.8-26.8 26.8-14.9 0-26.8-12-26.8-26.8s12-26.8 26.8-26.8 26.8 12 26.8 26.8zm76.1 27.2c-1.7-35.9-9.9-67.7-36.2-93.9-26.2-26.2-58-34.4-93.9-36.2-37-2.1-147.9-2.1-184.9 0-35.8 1.7-67.6 9.9-93.9 36.1s-34.4 58-36.2 93.9c-2.1 37-2.1 147.9 0 184.9 1.7 35.9 9.9 67.7 36.2 93.9s58 34.4 93.9 36.2c37 2.1 147.9 2.1 184.9 0 35.9-1.7 67.7-9.9 93.9-36.2 26.2-26.2 34.4-58 36.2-93.9 2.1-37 2.1-147.8 0-184.8zM398.8 388c-7.8 19.6-22.9 34.7-42.6 42.6-29.5 11.7-99.5 9-132.1 9s-102.7 2.6-132.1-9c-19.6-7.8-34.7-22.9-42.6-42.6-11.7-29.5-9-99.5-9-132.1s-2.6-102.7 9-132.1c7.8-19.6 22.9-34.7 42.6-42.6 29.5-11.7 99.5-9 132.1-9s102.7-2.6 132.1 9c19.6 7.8 34.7 22.9 42.6 42.6 11.7 29.5 9 99.5 9 132.1s2.7 102.7-9 132.1z"></path>',
			'viewbox' => '0 0 448 512',
		];

		$icons['houzz'] = [
			'title' => 'Houzz',
			'icon' => '<path d="M275.9 330.7H171.3V480H17V32h109.5v104.5l305.1 85.6V480H275.9z"></path>',
			'viewbox' => '0 0 448 512',
		];

		$icons['google-plus'] = [
			'title' => 'Google Plus',
			'icon' => '<path d="M248 8C111.1 8 0 119.1 0 256s111.1 248 248 248 248-111.1 248-248S384.9 8 248 8zm-70.7 372c-68.8 0-124-55.5-124-124s55.2-124 124-124c31.3 0 60.1 11 83 32.3l-33.6 32.6c-13.2-12.9-31.3-19.1-49.4-19.1-42.9 0-77.2 35.5-77.2 78.1s34.2 78.1 77.2 78.1c32.6 0 64.9-19.1 70.1-53.3h-70.1v-42.6h116.9c1.3 6.8 1.9 13.6 1.9 20.7 0 70.8-47.5 121.2-118.8 121.2zm230.2-106.2v35.5H372v-35.5h-35.5v-35.5H372v-35.5h35.5v35.5h35.2v35.5h-35.2z"></path>',
			'viewbox' => '0 0 496 512',
		];

		$icons['gitlab'] = [
			'title' => 'Gitlab',
			'icon' => '<path d="M105.2 24.9c-3.1-8.9-15.7-8.9-18.9 0L29.8 199.7h132c-.1 0-56.6-174.8-56.6-174.8zM.9 287.7c-2.6 8 .3 16.9 7.1 22l247.9 184-226.2-294zm160.8-88l94.3 294 94.3-294zm349.4 88l-28.8-88-226.3 294 247.9-184c6.9-5.1 9.7-14 7.2-22zM425.7 24.9c-3.1-8.9-15.7-8.9-18.9 0l-56.6 174.8h132z"></path>',
			'viewbox' => '0 0 512 512',
		];

		$icons['github'] = [
			'title' => 'Github',
			'icon' => '<path d="M165.9 397.4c0 2-2.3 3.6-5.2 3.6-3.3.3-5.6-1.3-5.6-3.6 0-2 2.3-3.6 5.2-3.6 3-.3 5.6 1.3 5.6 3.6zm-31.1-4.5c-.7 2 1.3 4.3 4.3 4.9 2.6 1 5.6 0 6.2-2s-1.3-4.3-4.3-5.2c-2.6-.7-5.5.3-6.2 2.3zm44.2-1.7c-2.9.7-4.9 2.6-4.6 4.9.3 2 2.9 3.3 5.9 2.6 2.9-.7 4.9-2.6 4.6-4.6-.3-1.9-3-3.2-5.9-2.9zM244.8 8C106.1 8 0 113.3 0 252c0 110.9 69.8 205.8 169.5 239.2 12.8 2.3 17.3-5.6 17.3-12.1 0-6.2-.3-40.4-.3-61.4 0 0-70 15-84.7-29.8 0 0-11.4-29.1-27.8-36.6 0 0-22.9-15.7 1.6-15.4 0 0 24.9 2 38.6 25.8 21.9 38.6 58.6 27.5 72.9 20.9 2.3-16 8.8-27.1 16-33.7-55.9-6.2-112.3-14.3-112.3-110.5 0-27.5 7.6-41.3 23.6-58.9-2.6-6.5-11.1-33.3 2.6-67.9 20.9-6.5 69 27 69 27 20-5.6 41.5-8.5 62.8-8.5s42.8 2.9 62.8 8.5c0 0 48.1-33.6 69-27 13.7 34.7 5.2 61.4 2.6 67.9 16 17.7 25.8 31.5 25.8 58.9 0 96.5-58.9 104.2-114.8 110.5 9.2 7.9 17 22.9 17 46.4 0 33.7-.3 75.4-.3 83.6 0 6.5 4.6 14.4 17.3 12.1C428.2 457.8 496 362.9 496 252 496 113.3 383.5 8 244.8 8zM97.2 352.9c-1.3 1-1 3.3.7 5.2 1.6 1.6 3.9 2.3 5.2 1 1.3-1 1-3.3-.7-5.2-1.6-1.6-3.9-2.3-5.2-1zm-10.8-8.1c-.7 1.3.3 2.9 2.3 3.9 1.6 1 3.6.7 4.3-.7.7-1.3-.3-2.9-2.3-3.9-2-.6-3.6-.3-4.3.7zm32.4 35.6c-1.6 1.3-1 4.3 1.3 6.2 2.3 2.3 5.2 2.6 6.5 1 1.3-1.3.7-4.3-1.3-6.2-2.2-2.3-5.2-2.6-6.5-1zm-11.4-14.7c-1.6 1-1.6 3.6 0 5.9 1.6 2.3 4.3 3.3 5.6 2.3 1.6-1.3 1.6-3.9 0-6.2-1.4-2.3-4-3.3-5.6-2z"></path>',
			'viewbox' => '0 0 496 512',
		];

		$icons['free-code-camp'] = [
			'title' => 'FreeCodeCamp',
			'icon' => '<path d="M69.3 144.5c-41 68.5-36.4 163 1 227C92.5 409.7 120 423.9 120 438c0 6.8-6 13-12.8 13C87.7 451 8 375.5 8 253.2c0-111.5 78-186 97.1-186 6 0 14.9 4.8 14.9 11.1 0 12.7-28.3 28.6-50.7 66.2zm195.8 213.8c4.5 1.8 12.3 5.2 12.3-1.2 0-2.7-2.2-2.9-4.3-3.6-8.5-3.4-14-7.7-19.1-15.2-8.2-12.1-10.1-24.2-10.1-38.6 0-32.1 44.2-37.9 44.2-70 0-12.3-7.7-15.9-7.7-19.3 0-2.2.7-2.2 2.9-2.2 8 0 19.1 13.3 22.5 19.8 2.2 4.6 2.4 6 2.4 11.1 0 7-.7 14.2-.7 21.3 0 27 31.9 19.8 31.9 6.8 0-6-3.6-11.6-3.6-17.4 0-.7 0-1.2.7-1.2 3.4 0 9.4 7.7 11.1 10.1 5.8 8.9 8.5 20.8 8.5 31.4 0 32.4-29.5 49-29.5 56 0 1 2.9 7.7 12.1 1.9 29.7-15.1 53.1-47.6 53.1-89.8 0-33.6-8.7-57.7-32.1-82.6-3.9-4.1-16.4-16.9-22.5-16.9-8.2 0 7.2 18.6 7.2 31.2 0 7.2-4.8 12.3-12.3 12.3-11.6 0-14.5-25.4-15.9-33.3-5.8-33.8-12.8-58.2-46.4-74.1-10.4-5-36.5-11.8-36.5-2.2 0 2.4 2.7 4.1 4.6 5.1 9.2 5.6 19.6 21.4 19.6 38.2 0 46.1-57.7 88.2-57.7 136.2-.2 40.3 28.1 72.6 65.3 86.2zM470.4 67c-6 0-14.4 6.5-14.4 12.6 0 8.7 12.1 19.6 17.6 25.4 81.6 85.1 78.6 214.3 17.6 291-7 8.9-35.3 35.3-35.3 43.5 0 5.1 8.2 11.4 13.2 11.4 25.4 0 98.8-80.8 98.8-185.7C568 145.9 491.8 67 470.4 67zm-42.3 323.1H167c-9.4 0-15.5 7.5-15.5 16.4 0 8.5 7 15.5 15.5 15.5h261.1c9.4 0 11.9-7.5 11.9-16.4 0-8.5-3.5-15.5-11.9-15.5z"></path>',
			'viewbox' => '0 0 576 512',
		];

		$icons[''] = [
			'title' => 'FourSquare',
			'icon' => '<path d="M323.1 3H49.9C12.4 3 0 31.3 0 49.1v433.8c0 20.3 12.1 27.7 18.2 30.1 6.2 2.5 22.8 4.6 32.9-7.1C180 356.5 182.2 354 182.2 354c3.1-3.4 3.4-3.1 6.8-3.1h83.4c35.1 0 40.6-25.2 44.3-39.7l48.6-243C373.8 25.8 363.1 3 323.1 3zm-16.3 73.8l-11.4 59.7c-1.2 6.5-9.5 13.2-16.9 13.2H172.1c-12 0-20.6 8.3-20.6 20.3v13c0 12 8.6 20.6 20.6 20.6h90.4c8.3 0 16.6 9.2 14.8 18.2-1.8 8.9-10.5 53.8-11.4 58.8-.9 4.9-6.8 13.5-16.9 13.5h-73.5c-13.5 0-17.2 1.8-26.5 12.6 0 0-8.9 11.4-89.5 108.3-.9.9-1.8.6-1.8-.3V75.9c0-7.7 6.8-16.6 16.6-16.6h219c8.2 0 15.6 7.7 13.5 17.5z"></path>',
			'viewbox' => '0 0 368 512',
		];

		$icons['flickr'] = [
			'title' => 'Flickr',
			'icon' => '<path d="M400 32H48C21.5 32 0 53.5 0 80v352c0 26.5 21.5 48 48 48h352c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48zM144.5 319c-35.1 0-63.5-28.4-63.5-63.5s28.4-63.5 63.5-63.5 63.5 28.4 63.5 63.5-28.4 63.5-63.5 63.5zm159 0c-35.1 0-63.5-28.4-63.5-63.5s28.4-63.5 63.5-63.5 63.5 28.4 63.5 63.5-28.4 63.5-63.5 63.5z"></path>',
			'viewbox' => '0 0 448 512',
		];

		$icons['facebook'] = [
			'title' => 'Facebook',
			'icon' => '<path d="M504 256C504 119 393 8 256 8S8 119 8 256c0 123.78 90.69 226.38 209.25 245V327.69h-63V256h63v-54.64c0-62.15 37-96.48 93.67-96.48 27.14 0 55.52 4.84 55.52 4.84v61h-31.28c-30.8 0-40.41 19.12-40.41 38.73V256h68.78l-11 71.69h-57.78V501C413.31 482.38 504 379.78 504 256z"></path>',
			'viewbox' => '0 0 512 512',
		];

		$icons['facebook-f'] = [
			'title' => 'Facebook',
			'icon' => '<path d="M279.14 288l14.22-92.66h-88.91v-60.13c0-25.35 12.42-50.06 52.24-50.06h40.42V6.26S260.43 0 225.36 0c-73.22 0-121.08 44.38-121.08 124.72v70.62H22.89V288h81.39v224h100.17V288z"></path>',
			'viewbox' => '0 0 320 512',
		];

		$icons['dribbble'] = [
			'title' => 'Dribbble',
			'icon' => '<path d="M256 8C119.252 8 8 119.252 8 256s111.252 248 248 248 248-111.252 248-248S392.748 8 256 8zm163.97 114.366c29.503 36.046 47.369 81.957 47.835 131.955-6.984-1.477-77.018-15.682-147.502-6.818-5.752-14.041-11.181-26.393-18.617-41.614 78.321-31.977 113.818-77.482 118.284-83.523zM396.421 97.87c-3.81 5.427-35.697 48.286-111.021 76.519-34.712-63.776-73.185-116.168-79.04-124.008 67.176-16.193 137.966 1.27 190.061 47.489zm-230.48-33.25c5.585 7.659 43.438 60.116 78.537 122.509-99.087 26.313-186.36 25.934-195.834 25.809C62.38 147.205 106.678 92.573 165.941 64.62zM44.17 256.323c0-2.166.043-4.322.108-6.473 9.268.19 111.92 1.513 217.706-30.146 6.064 11.868 11.857 23.915 17.174 35.949-76.599 21.575-146.194 83.527-180.531 142.306C64.794 360.405 44.17 310.73 44.17 256.323zm81.807 167.113c22.127-45.233 82.178-103.622 167.579-132.756 29.74 77.283 42.039 142.053 45.189 160.638-68.112 29.013-150.015 21.053-212.768-27.882zm248.38 8.489c-2.171-12.886-13.446-74.897-41.152-151.033 66.38-10.626 124.7 6.768 131.947 9.055-9.442 58.941-43.273 109.844-90.795 141.978z"></path>',
			'viewbox' => '0 0 512 512',
		];

		$icons['discord'] = [
			'title' => 'Discord',
			'icon' => '<path d="M60.1045 12.4861C55.5792 10.4097 50.7265 8.87986 45.6527 8.00368C45.5603 7.98677 45.468 8.02902 45.4204 8.11354C44.7963 9.22356 44.105 10.6717 43.6209 11.8099C38.1637 10.9929 32.7345 10.9929 27.3892 11.8099C26.905 10.6464 26.1886 9.22356 25.5617 8.11354C25.5141 8.03184 25.4218 7.98959 25.3294 8.00368C20.2584 8.87706 15.4057 10.4069 10.8776 12.4861C10.8384 12.503 10.8048 12.5312 10.7825 12.5678C1.57795 26.3192 -0.943561 39.7326 0.293408 52.9797C0.299005 53.0445 0.335386 53.1065 0.385761 53.1459C6.45866 57.6057 12.3413 60.3132 18.1147 62.1078C18.2071 62.136 18.305 62.1022 18.3638 62.0261C19.7295 60.1611 20.9469 58.1946 21.9907 56.1266C22.0523 56.0055 21.9935 55.8618 21.8676 55.8139C19.9366 55.0814 18.0979 54.1883 16.3292 53.1741C16.1893 53.0924 16.1781 52.8923 16.3068 52.7965C16.679 52.5176 17.0513 52.2274 17.4067 51.9344C17.471 51.8809 17.5606 51.8696 17.6362 51.9034C29.2558 57.2085 41.8354 57.2085 53.3179 51.9034C53.3935 51.8668 53.4831 51.8781 53.5502 51.9316C53.9057 52.2246 54.2779 52.5176 54.6529 52.7965C54.7816 52.8923 54.7732 53.0924 54.6333 53.1741C52.8646 54.208 51.0259 55.0814 49.0921 55.8111C48.9662 55.859 48.9102 56.0055 48.9718 56.1266C50.038 58.1917 51.2554 60.1582 52.5959 62.0233C52.6519 62.1022 52.7526 62.136 52.845 62.1078C58.6464 60.3132 64.529 57.6057 70.6019 53.1459C70.6551 53.1065 70.6887 53.0473 70.6943 52.9825C72.1747 37.6674 68.2147 24.364 60.1968 12.5706C60.1772 12.5312 60.1437 12.503 60.1045 12.4861ZM23.7259 44.9136C20.2276 44.9136 17.3451 41.7019 17.3451 37.7576C17.3451 33.8133 20.1717 30.6016 23.7259 30.6016C27.308 30.6016 30.1626 33.8415 30.1066 37.7576C30.1066 41.7019 27.28 44.9136 23.7259 44.9136ZM47.3178 44.9136C43.8196 44.9136 40.9371 41.7019 40.9371 37.7576C40.9371 33.8133 43.7636 30.6016 47.3178 30.6016C50.9 30.6016 53.7545 33.8415 53.6986 37.7576C53.6986 41.7019 50.9 44.9136 47.3178 44.9136Z" />',
			'viewbox' => '0 0 71 71',
		];

		$icons['digg'] = [
			'title' => 'Digg',
			'icon' => '<path d="M81.7 172.3H0v174.4h132.7V96h-51v76.3zm0 133.4H50.9v-92.3h30.8v92.3zm297.2-133.4v174.4h81.8v28.5h-81.8V416H512V172.3H378.9zm81.8 133.4h-30.8v-92.3h30.8v92.3zm-235.6 41h82.1v28.5h-82.1V416h133.3V172.3H225.1v174.4zm51.2-133.3h30.8v92.3h-30.8v-92.3zM153.3 96h51.3v51h-51.3V96zm0 76.3h51.3v174.4h-51.3V172.3z"></path>',
			'viewbox' => '0 0 512 512',
		];

		$icons['deviantart'] = [
			'title' => 'Deviantart',
			'icon' => '<path d="M320 93.2l-98.2 179.1 7.4 9.5H320v127.7H159.1l-13.5 9.2-43.7 84c-.3 0-8.6 8.6-9.2 9.2H0v-93.2l93.2-179.4-7.4-9.2H0V102.5h156l13.5-9.2 43.7-84c.3 0 8.6-8.6 9.2-9.2H320v93.1z"></path>',
			'viewbox' => '0 0 320 512',
		];

		$icons['delicious'] = [
			'title' => 'Delicious',
			'icon' => '<path d="M446.5 68c-.4-1.5-.9-3-1.4-4.5-.9-2.5-2-4.8-3.3-7.1-1.4-2.4-3-4.8-4.7-6.9-2.1-2.5-4.4-4.8-6.9-6.8-1.1-.9-2.2-1.7-3.3-2.5-1.3-.9-2.6-1.7-4-2.4-1.8-1-3.6-1.8-5.5-2.5-1.7-.7-3.5-1.3-5.4-1.7-3.8-1-7.9-1.5-12-1.5H48C21.5 32 0 53.5 0 80v352c0 4.1.5 8.2 1.5 12 2 7.7 5.8 14.6 11 20.3 1 1.1 2.1 2.2 3.3 3.3 5.7 5.2 12.6 9 20.3 11 3.8 1 7.9 1.5 12 1.5h352c26.5 0 48-21.5 48-48V80c-.1-4.1-.6-8.2-1.6-12zM416 432c0 8.8-7.2 16-16 16H224V256H32V80c0-8.8 7.2-16 16-16h176v192h192z"></path>',
			'viewbox' => '0 0 448 512',
		];

		$icons['codepen'] = [
			'title' => 'Codepen',
			'icon' => '<path d="M502.285 159.704l-234-156c-7.987-4.915-16.511-4.96-24.571 0l-234 156C3.714 163.703 0 170.847 0 177.989v155.999c0 7.143 3.714 14.286 9.715 18.286l234 156.022c7.987 4.915 16.511 4.96 24.571 0l234-156.022c6-3.999 9.715-11.143 9.715-18.286V177.989c-.001-7.142-3.715-14.286-9.716-18.285zM278 63.131l172.286 114.858-76.857 51.429L278 165.703V63.131zm-44 0v102.572l-95.429 63.715-76.857-51.429L234 63.131zM44 219.132l55.143 36.857L44 292.846v-73.714zm190 229.715L61.714 333.989l76.857-51.429L234 346.275v102.572zm22-140.858l-77.715-52 77.715-52 77.715 52-77.715 52zm22 140.858V346.275l95.429-63.715 76.857 51.429L278 448.847zm190-156.001l-55.143-36.857L468 219.132v73.714z"></path>',
			'viewbox' => '0 0 512 512',
		];

		$icons['bitbucket'] = [
			'title' => 'Bitbucket',
			'icon' => '<path d="M22.2 32A16 16 0 0 0 6 47.8a26.35 26.35 0 0 0 .2 2.8l67.9 412.1a21.77 21.77 0 0 0 21.3 18.2h325.7a16 16 0 0 0 16-13.4L505 50.7a16 16 0 0 0-13.2-18.3 24.58 24.58 0 0 0-2.8-.2L22.2 32zm285.9 297.8h-104l-28.1-147h157.3l-25.2 147z"></path>',
			'viewbox' => '0 0 512 512',
		];

		$icons['android'] = [
			'title' => 'Android',
			'icon' => '<path d="M89.6 204.5v115.8c0 15.4-12.1 27.7-27.5 27.7-15.3 0-30.1-12.4-30.1-27.7V204.5c0-15.1 14.8-27.5 30.1-27.5 15.1 0 27.5 12.4 27.5 27.5zm10.8 157c0 16.4 13.2 29.6 29.6 29.6h19.9l.3 61.1c0 36.9 55.2 36.6 55.2 0v-61.1h37.2v61.1c0 36.7 55.5 36.8 55.5 0v-61.1h20.2c16.2 0 29.4-13.2 29.4-29.6V182.1H100.4v179.4zm248-189.1H99.3c0-42.8 25.6-80 63.6-99.4l-19.1-35.3c-2.8-4.9 4.3-8 6.7-3.8l19.4 35.6c34.9-15.5 75-14.7 108.3 0L297.5 34c2.5-4.3 9.5-1.1 6.7 3.8L285.1 73c37.7 19.4 63.3 56.6 63.3 99.4zm-170.7-55.5c0-5.7-4.6-10.5-10.5-10.5-5.7 0-10.2 4.8-10.2 10.5s4.6 10.5 10.2 10.5c5.9 0 10.5-4.8 10.5-10.5zm113.4 0c0-5.7-4.6-10.5-10.2-10.5-5.9 0-10.5 4.8-10.5 10.5s4.6 10.5 10.5 10.5c5.6 0 10.2-4.8 10.2-10.5zm94.8 60.1c-15.1 0-27.5 12.1-27.5 27.5v115.8c0 15.4 12.4 27.7 27.5 27.7 15.4 0 30.1-12.4 30.1-27.7V204.5c0-15.4-14.8-27.5-30.1-27.5z"></path>',
			'viewbox' => '0 0 448 512',
		];

		$icons['apple'] = [
			'title' => 'Apple',
			'icon' => '<path d="M318.7 268.7c-.2-36.7 16.4-64.4 50-84.8-18.8-26.9-47.2-41.7-84.7-44.6-35.5-2.8-74.3 20.7-88.5 20.7-15 0-49.4-19.7-76.4-19.7C63.3 141.2 4 184.8 4 273.5q0 39.3 14.4 81.2c12.8 36.7 59 126.7 107.2 125.2 25.2-.6 43-17.9 75.8-17.9 31.8 0 48.3 17.9 76.4 17.9 48.6-.7 90.4-82.5 102.6-119.3-65.2-30.7-61.7-90-61.7-91.9zm-56.6-164.2c27.3-32.4 24.8-61.9 24-72.5-24.1 1.4-52 16.4-67.9 34.9-17.5 19.8-27.8 44.3-25.6 71.9 26.1 2 49.9-11.4 69.5-34.3z"></path>',
			'viewbox' => '0 0 384 512',
		];

		$icons['behance'] = [
			'title' => 'Behance',
			'icon' => '<path d="M232 237.2c31.8-15.2 48.4-38.2 48.4-74 0-70.6-52.6-87.8-113.3-87.8H0v354.4h171.8c64.4 0 124.9-30.9 124.9-102.9 0-44.5-21.1-77.4-64.7-89.7zM77.9 135.9H151c28.1 0 53.4 7.9 53.4 40.5 0 30.1-19.7 42.2-47.5 42.2h-79v-82.7zm83.3 233.7H77.9V272h84.9c34.3 0 56 14.3 56 50.6 0 35.8-25.9 47-57.6 47zm358.5-240.7H376V94h143.7v34.9zM576 305.2c0-75.9-44.4-139.2-124.9-139.2-78.2 0-131.3 58.8-131.3 135.8 0 79.9 50.3 134.7 131.3 134.7 61.3 0 101-27.6 120.1-86.3H509c-6.7 21.9-34.3 33.5-55.7 33.5-41.3 0-63-24.2-63-65.3h185.1c.3-4.2.6-8.7.6-13.2zM390.4 274c2.3-33.7 24.7-54.8 58.5-54.8 35.4 0 53.2 20.8 56.2 54.8H390.4z"></path>',
			'viewbox' => '0 0 576 512',
		];

		$icons['link'] = [
			'title' => 'Link',
			'icon' => '<path d="M7.8 24c0-3.42 2.78-6.2 6.2-6.2h8V14h-8C8.48 14 4 18.48 4 24s4.48 10 10 10h8v-3.8h-8c-3.42 0-6.2-2.78-6.2-6.2zm8.2 2h16v-4H16v4zm18-12h-8v3.8h8c3.42 0 6.2 2.78 6.2 6.2s-2.78 6.2-6.2 6.2h-8V34h8c5.52 0 10-4.48 10-10s-4.48-10-10-10z"/>',
			'viewbox' => '0 0 48 48',
		];

		$icons['print'] = [
			'title' => 'Print',
			'icon' => '<path d="M618 242l104 0c9,0 17,8 17,17l0 20c0,9 -8,17 -17,17l-104 0c-9,0 -17,-8 -17,-17l0 -20c0,-9 8,-17 17,-17zm-429 -54l0 -109c0,-10 4,-19 10,-25 7,-7 16,-11 25,-11l398 0c10,0 19,4 25,11 7,6 11,15 11,25l0 109 112 0c10,0 18,4 25,10 6,6 10,15 10,25l0 363c0,9 -4,18 -10,24 -7,7 -15,11 -25,11l-116 0 0 147c0,10 -4,19 -10,25 -6,6 -15,10 -25,10l-391 0c-10,0 -19,-4 -25,-10 -7,-6 -11,-15 -11,-25l0 -147 -115 0c-10,0 -19,-4 -25,-11 -7,-6 -11,-15 -11,-24l0 -363c0,-10 4,-19 11,-25 6,-6 15,-10 25,-10l112 0zm34 -109l0 109 401 0 0 -109c0,0 0,-1 -1,-1 0,-1 0,-1 -1,-1l-398 0c0,0 0,0 -1,1 0,0 0,1 0,1zm78 534c-9,0 -16,-7 -16,-16 0,-10 7,-17 16,-17l244 0c10,0 17,7 17,17 0,9 -7,16 -17,16l-244 0zm0 98c-9,0 -16,-7 -16,-17 0,-9 7,-17 16,-17l244 0c10,0 17,8 17,17 0,10 -7,17 -17,17l-244 0zm391 -189l-38 0 0 65 116 0c0,0 1,0 1,-1 0,0 1,0 1,0l0 -363c0,-1 -1,-1 -1,-1 0,0 -1,-1 -1,-1l-693 0c-1,0 -1,1 -2,1 0,0 0,0 0,1l0 363c0,0 0,0 0,0 1,1 1,1 2,1l115 0 0 -65 -37 0 0 -34 537 0 0 34zm-72 246l0 -246 -394 0 0 246c0,1 0,1 0,1 1,0 1,0 2,0l391 0c1,0 1,0 1,0 0,0 0,0 0,-1z"/>',
			'viewbox' => '0 0 847 847',
		];

		$icons['patreon'] = [
			'title' => 'Patreon',
			'icon' => '<path d="M15.386.524c-4.764 0-8.64 3.876-8.64 8.64 0 4.75 3.876 8.613 8.64 8.613 4.75 0 8.614-3.864 8.614-8.613C24 4.4 20.136.524 15.386.524M.003 23.537h4.22V.524H.003"/>',
			'viewbox' => '0 0 24 24',
		];

		$icons['tiktok'] = [
			'title' => 'Tiktok',
			'icon' => '<path d="M11.4440412,0.71 L15.5479631,0.71 C15.5479631,0.71 15.3202617,5.98221579 21.2477811,6.35223069 L21.2477811,10.4276899 C21.2477811,10.4276899 18.0844516,10.6262668 15.5479631,8.6894804 L15.592312,17.1038441 C15.592312,21.3045219 12.1870544,24.7098782 7.9863767,24.71 C3.78569896,24.7101218 0.380243896,21.3049631 0.380000193,17.1042854 C0.37975649,12.9036077 3.78481643,9.49805381 7.98549415,9.49768825 L9.05251384,9.49768825 L9.05251384,13.5777809 L9.05251384,13.6644928 C7.62604207,13.2197214 6.07524473,13.7415075 5.20776375,14.9581093 C4.34028278,16.1747112 4.35237211,17.8108918 5.23773574,19.0145423 C6.12309937,20.2181928 7.68143767,20.7170063 9.10118145,20.2512048 C10.5209252,19.7854034 11.4808797,18.4603674 11.4811089,16.9661642 L11.4440412,0.71 Z" fill-rule="nonzero"></path>',
			'viewbox' => '0 0 22 25',
		];

		return apply_filters('rey/svg_icons_raw', $icons);

	}
endif;
