<?php

// Support for PW Woocommerce Advanced Gift Rules
// Remove gifts from the cart if the gift has country restrictions
add_filter('custom_gift_field_per_rule_check', function ($rule) {
	$allowed_products = array();
	foreach ($rule['pw_gifts'] as $product_id) {
		if (!vcwccr_is_restricted($product_id)) {
			$allowed_products[] = true;
		}
	}

	if (count($allowed_products) !== count($rule['pw_gifts'])) {
		return false;
	}
	return $rule;
});
