<?php
if (!class_exists('WCACR_WCFM')) {

	class WCACR_WCFM {

		static private $instance = false;

		private function __construct() {
			
		}

		function init() {

			if (!class_exists('WCFM')) {
				return;
			}

			add_filter('vcwccr_tab_settings_filter', array($this, 'add_settings'));
			add_action('end_wcfm_products_manage', array($this, 'display_country_restrictions_fields'), 600);
			add_action('after_wcfm_products_manage_meta_save', array($this, 'save_restrictions_fields'), 500, 2);
			add_action('after_wcfm_products_manage_meta_save', array($this, 'maybe_auto_set_restriction'), 500, 2);
		}

		function maybe_auto_set_restriction($new_product_id, $wcfm_products_manage_form_data) {
			$settings = get_option('wcacr_wcfm_allow_country_restrictions');
			if (!$settings || $settings !== 'vendor_country') {
				return;
			}

			if (empty((int) $wcfm_products_manage_form_data['pro_id'])) {
				update_post_meta($new_product_id, 'vcwccr_selected_countries', wcacr_get_user_country());
				update_post_meta($new_product_id, 'vcwccr_availability_operator', '1');
				wcacr_save_disallowed_countries($new_product_id, array(wcacr_get_user_country()), 1);
			}
		}

		function save_restrictions_fields($new_product_id, $wcfm_products_manage_form_data) {
			$settings = get_option('wcacr_wcfm_allow_country_restrictions');
			if (!$settings || $settings !== 'custom') {
				return;
			}

			if (!function_exists('vcwccr_save_product_custom_fields')) {
				require_once VCWCCR_PATH . 'backend/product-custom-fields.php';
			}

			if (isset($wcfm_products_manage_form_data['product_selected_countries'])) {
				$_POST['product_selected_countries'] = $wcfm_products_manage_form_data['product_selected_countries'];
			}
			if (isset($wcfm_products_manage_form_data['product_country_availability_operator'])) {
				$_POST['product_country_availability_operator'] = $wcfm_products_manage_form_data['product_country_availability_operator'];
			}
			vcwccr_save_product_custom_fields($new_product_id);
		}

		public function display_country_restrictions_fields($product_id) {
			global $WCFM, $WCMp;

			$settings = get_option('wcacr_wcfm_allow_country_restrictions');
			if (!$settings || $settings !== 'custom') {
				return;
			}
			?>
			<div class="page_collapsible products_manage_commission simple variable grouped external booking" id="wcfm_products_manage_form_commission_head"><label class="wcfmfa fa-percent"></label><?php _e('Country restrictions', VCWCCR_TEXT_DOMAIN); ?><span></span></div>
			<div class="wcfm-container simple variable external grouped booking">
				<div id="wcfm_products_manage_form_commission_expander" class="wcfm-content">
					<p><?php _e('Configure in which countries your product will be sold', VCWCCR_TEXT_DOMAIN); ?></p>
					<?php
					$selected_countries_raw = get_post_meta($product_id, 'vcwccr_selected_countries', true);
					$selected_countries_raw = empty($selected_countries_raw) ? '' : $selected_countries_raw;
					$selected_countries = explode(',', strval($selected_countries_raw));
					$WCFM->wcfm_fields->wcfm_generate_form_field(array(
						"product_selected_countries" => array(
							'label' => __('Selected countries', VCWCCR_TEXT_DOMAIN),
							'type' => 'select',
							'attributes' => array('multiple' => 'multiple'),
							'class' => 'wcfm-select vcwccr-select2',
							'options' => vcwccr_get_countries_with_continents(),
							'value' => $selected_countries)
					));
					$WCFM->wcfm_fields->wcfm_generate_form_field(array(
						"product_country_availability_operator" => array(
							'label' => __('Availability', VCWCCR_TEXT_DOMAIN),
							'type' => 'select',
							'class' => 'wcfm-select',
							'options' => vcwccr_get_country_availability_operators(),
							'value' => get_post_meta($product_id, 'vcwccr_availability_operator', true))
					));
					?>
				</div>
			</div>
			<!-- end collapsible -->
			<div class="wcfm_clearfix"></div>
			<script>
				jQuery(function ($) {
					$('.vcwccr-select2').select2();
				});
			</script>
			<?php
		}

		function add_settings($settings) {
			$settings['wcfm'] = array(
				'title' => __('WCFM', VCWCCR_TEXT_DOMAIN),
				'wcacr_wcfm_allow_country_restrictions' => array(
					'name' => __('Allow to select country restrictions in the vendor dashboard?', VCWCCR_TEXT_DOMAIN),
					'type' => 'select',
					"options" => array(
						'' => __('No, vendor products will not have custom restrictions', VCWCCR_TEXT_DOMAIN),
						'vendor_country' => __('Automatically restrict products to the country of the vendor', VCWCCR_TEXT_DOMAIN),
						'custom' => __('Allow the vendor to select custom country restrictions', VCWCCR_TEXT_DOMAIN),
					),
					'id' => 'wcacr_wcfm_allow_country_restrictions',
				),
			);
			return $settings;
		}

		/**
		 * Creates or returns an instance of this class.
		 */
		static function get_instance() {
			if (null == WCACR_WCFM::$instance) {
				WCACR_WCFM::$instance = new WCACR_WCFM();
				WCACR_WCFM::$instance->init();
			}
			return WCACR_WCFM::$instance;
		}

		function __set($name, $value) {
			$this->$name = $value;
		}

		function __get($name) {
			return $this->$name;
		}

	}

}

if (!function_exists('WCACR_WCFM_Obj')) {

	function WCACR_WCFM_Obj() {
		return WCACR_WCFM::get_instance();
	}

}
WCACR_WCFM_Obj();
