<?php

/**
 * Compatibility with "Aelia Currency Switcher for WooCommerce" by Aelia
 */
add_filter('vcwccr_set_user_country', function ($my_country, $geolocation_method) {
	if (!class_exists('\Aelia\WC\CurrencySwitcher\WC_Aelia_Currencies_Manager')) {
		return $my_country;
	}
	$currency = \Aelia\WC\CurrencySwitcher\WC_Aelia_Currencies_Manager::factory()->get_country_currency($my_country);
	if ($currency) {
		$_POST['aelia_customer_country'] = $currency;
		if (!headers_sent()) {
			$cookie_name = 'aelia_cs_selected_currency';
			setcookie($cookie_name, $currency, time() + DAY_IN_SECONDS, "/");
			$_COOKIE[$cookie_name] = $currency;
		}
	}
	return $my_country;
}, 99, 2);
/**
 * Compatibility with "Aelia Currency Switcher for WooCommerce" by Aelia
 */
/*
add_filter('wcacr_country_selector/link_url', function ($url, $country_data) {
	if (!class_exists('\Aelia\WC\CurrencySwitcher\WC_Aelia_Currencies_Manager')) {
		return $url;
	}
	$currency = \Aelia\WC\CurrencySwitcher\WC_Aelia_Currencies_Manager::factory()->get_country_currency($country_data['abbreviation']);
	$url = add_query_arg('aelia_cs_currency', $currency, $url);
	return $url;
}, 10, 2);*/
