<?php

defined('ABSPATH') or die('Cheatin&#8217; uh?');

if (function_exists('rocket_after_update_wcacr_options')) {
	return;
}

/**
 * Update .htaccess & config files when the Geolocation option is updated
 *
 * @since 2.7
 *
 * @param array $old_value Previous setting values.
 * @param array $value Submitted settings values.
 */
function rocket_after_update_wcacr_options() {
	if (!function_exists('flush_rocket_htaccess')) {
		return;
	}
	// Update the WP Rocket rules on the .htaccess file.
	flush_rocket_htaccess();

	// Update the config file.
	rocket_generate_config_file();
}

add_action('woocommerce_update_options_variations_per_country_tab', 'rocket_after_update_wcacr_options', 99);

/**
 * Generate a caching file depending on the currency cookie value
 */
add_filter('rocket_htaccess_mod_rewrite', '__return_false');
add_filter('rocket_cache_dynamic_cookies', 'rocket_add_wcacr_dynamic_cookies');
add_filter('rocket_cache_mandatory_cookies', 'rocket_add_wcacr_mandatory_cookie');

/**
 * Add the Aelia Currency Switcher cookies to the dynamic cookies list
 *
 * @since 2.7
 *
 * @param array $cookies Cookies to use for dynamic caching.
 * @return array Updated cookies list
 */
function rocket_add_wcacr_dynamic_cookies($cookies) {
	$cookies[] = WCACR_USER_COUNTRY_COOKIE;
	return $cookies;
}

/**
 * Add the Aelia Currency Switcher to the list of mandatory cookies before generating caching files
 *
 * @since 2.7
 *
 * @param array $cookies Mandatory cookies to serve the cache.
 * @return array Updated cookies list
 */
function rocket_add_wcacr_mandatory_cookie($cookies) {
	$cookies[] = WCACR_USER_COUNTRY_COOKIE;

	return $cookies;
}
